"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('client', 'about');

class PatternflyNavigation extends _react.default.PureComponent {
  /** render menu options specified by client/config.d/about.json */
  renderSideNavMenu(menuIdx) {
    const thisNav = this.props.current.allNavs[menuIdx];
    return _react.default.createElement(_reactCore.NavExpandable, {
      title: strings(thisNav.title),
      key: menuIdx,
      isActive: this.props.current.current.menuIdx === menuIdx,
      isExpanded: true,
      className: menuIdx === 0 ? 'sidecar-header-name-content' : undefined
    }, thisNav.tabs.map((mode, idx) => {
      const isActive = this.props.current.current.menuIdx === menuIdx && this.props.current.current.tabIdx === idx;
      return _react.default.createElement(_reactCore.NavItem, {
        href: "#" // needed for tab navigation
        ,
        key: idx,
        "data-mode": mode.mode,
        isActive: isActive,
        onClick: evt => {
          evt.stopPropagation();
          this.props.changeCurrent(menuIdx, idx);
        },
        onMouseDown: event => event.preventDefault()
      }, _react.default.createElement("span", {
        className: "kui--mode-placeholder",
        "data-mode": mode.mode,
        "data-current": isActive
      }, strings(mode.label || mode.mode)));
    }));
  }

  renderSideNavLink(idx, link) {
    if ((0, _core.isLinkWithCommand)(link)) {
      return _react.default.createElement(_reactCore.NavItem, {
        className: "kui--nav-command-link",
        "data-link": strings(link.label),
        key: idx,
        to: "#",
        onClick: () => this.props.tab.REPL.pexec(link.command)
      }, strings(link.label));
    } else {
      return _react.default.createElement(_reactCore.NavItem, {
        className: "kui--nav-href-link",
        "data-link": strings(link.label),
        key: idx,
        target: "_blank",
        to: link.href
      }, strings(link.label));
    }
  }

  render() {
    return _react.default.createElement(_reactCore.Nav, {
      "aria-label": "Side navigation",
      theme: "dark"
    }, _react.default.createElement(_reactCore.NavList, null, this.props.current.allNavs.map((nav, idx) => this.renderSideNavMenu(idx)), this.props.current.allLinks.map((link, idx) => this.renderSideNavLink(idx, link))));
  }

}

exports.default = PatternflyNavigation;