import React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import BlockModel from '../Views/Terminal/Block/BlockModel';
import '../../../web/css/static/InputStripeExperimental.scss';
interface Props {
    tab?: KuiTab;
    /** tab uuid; this is grafted in for you, by TabContent */
    uuid?: string;
}
interface StyleRange {
    style: string;
    text: string;
}
interface State {
    idx: number;
    model: BlockModel;
    inputCells: string[];
    inputRanges: StyleRange[];
    inputSelectionStart: number;
    inputSelectionEnd: number;
}
export default class InputStripe extends React.PureComponent<Props, State> {
    private _caret;
    private _caretBlinker;
    private _focusElement;
    constructor(props: Props);
    /** Parse out the given command line into StyleRanges */
    private parse;
    /** Command has completed in our tab */
    private onOutputRender;
    /** Underlying Input element has changed content */
    private onInputChange;
    /** User has clicked on the underlying Input element */
    private onInputClick;
    /** onKeyUp in the underlying Input element */
    private onInputKeyUp;
    /** onMouseDown in the underlying Input element */
    private onInputMouseDown;
    /** onBlur in the underlying Input element */
    private onInputBlur;
    /** onFocus in the underlying Input element */
    private onInputFocus;
    /** Render the typed characters */
    private typedCharacters;
    private underlayFill;
    private underlaySelection;
    private initCaret;
    private underlayCaret;
    private underlay;
    render(): JSX.Element;
}
export {};
