import React from 'react';
import CommonClientProps from './props/Common';
import KuiConfiguration from './KuiConfiguration';
export declare type Props = Partial<KuiConfiguration> & CommonClientProps & {
    /** no Kui bootstrap needed? */
    noBootstrap?: boolean;
    /** operate in bottom Input mode? rather than as a conventional Input/Output terminal */
    bottomInput?: true | React.ReactNode;
    /** Elements to place between TabContainer and StatusStripe */
    toplevel?: React.ReactNode | React.ReactNode[];
    /** do not echo the command? */
    quietExecCommand?: boolean;
    /** initial tab title */
    initialTabTitle?: string;
};
declare type State = KuiConfiguration & {
    userOverrides?: KuiConfiguration;
    isBootstrapped: boolean;
    commandLine?: string[];
    quietExecCommand?: boolean;
};
/**
 * Render the main body of our client.
 *
 * |Notes on Session Initialization|: to provide custom views for
 * session initialization (only relevant for browser-based hosted
 * Kui), you can instantiate <Kui/> with these properties (defined in
 * KuiConfiguration), show here with some sample views:
 *
 * <Kui
 *    loading={<div className="kui--hero-text">Hold on...</div>}
 *    reinit={<div className="kui--hero-text">Connection broken...</div>}
 *    loadingError={err => <div className="kui--hero-text">{err.toString()}</div>}
 *    loadingDone={<div>Welcome to Kui</div>}
 * />
 *
 */
export declare class Kui extends React.PureComponent<Props, State> {
    constructor(props: Props);
    private defaultFeatureFlag;
    private defaultLoading;
    private defaultReinit;
    private defaultLoadingDone;
    private defaultLoadingError;
    /**
     * For browser-based clients, this defines the default UI for
     * session initialization.
     *
     */
    private defaultSessionBehavior;
    private onThemeChange;
    /**
     * Props to pass to StatusStripe. This allows us to set the desired
     * status stripe color at startup time, rather than seeing the
     * default color, followed quickly by a change to the color desired
     * by the controller backing the given `props.commandLine`. The
     * controller may still want to specialize the status stripe
     * further, but at least we can avoid that odd
     * e.g. defaultColor-then-blue effect.
     *
     */
    private statusStripeProps;
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    private firstTab;
    private onTabReady;
    private readonly _onTabReady;
    render(): JSX.Element;
}
export default Kui;
