/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import React from 'react';
import { encodeComponent, eventChannelUnsafe, flatten, getPersistedThemeChoice, i18n, pexecInCurrentTab, uiThemes } from '@kui-shell/core';
import { Loading } from '../../..';
import DropdownWidget from './DropdownWidget';
const strings = i18n('plugin-client-common');
export default class Settings extends React.PureComponent {
    constructor(props) {
        super(props);
        this.state = {
            currentTheme: undefined,
            themes: []
        };
        this.recomputeThemeList();
        eventChannelUnsafe.on('/theme/change', ({ theme }) => {
            this.setState({ currentTheme: theme });
        });
    }
    recomputeThemeList() {
        return __awaiter(this, void 0, void 0, function* () {
            const [currentTheme, themes] = yield Promise.all([
                getPersistedThemeChoice(),
                uiThemes()
                    .then(_ => _.map(({ themes }) => themes))
                    .then(flatten)
            ]);
            this.setState({
                currentTheme,
                themes: themes
            });
        });
    }
    header() {
        if (!this.state.currentTheme) {
            return React.createElement(Loading, null);
        }
        else {
            return (React.createElement(React.Fragment, null,
                React.createElement("div", null, strings('Current Theme')),
                React.createElement("div", null,
                    React.createElement("strong", null, this.state.currentTheme)),
                React.createElement("div", { className: "sub-text even-smaller-text" }, this.changeTheme())));
        }
    }
    body() {
        if (!this.state.currentTheme) {
            return React.createElement(Loading, null);
        }
        else {
            return React.createElement(React.Fragment, null);
        }
    }
    /** @return UI for changing themes */
    changeTheme() {
        return (React.createElement("a", { href: "#", onClick: () => pexecInCurrentTab('themes') }, strings('Switch theme')));
    }
    render() {
        //            aria-label="Settings"
        //            tabIndex={0}
        if (!this.state || !this.state.currentTheme) {
            return React.createElement(React.Fragment, null);
        }
        return (React.createElement(DropdownWidget, { id: "kui--settings-widget", title: strings('Switch theme'), actions: this.state.themes.map(_ => ({
                label: _.name,
                isSelected: _.name === this.state.currentTheme,
                handler: () => pexecInCurrentTab(`theme set ${encodeComponent(_.name)}`)
            })) }));
    }
}
//# sourceMappingURL=Settings.js.map