import React from 'react';
import TabModel from './TabModel';
import { TabContentOptions } from './TabContent';
import { TopTabStripeConfiguration } from './TopTabStripe';
import '../../../web/css/static/TabContainer.scss';
declare type Props = TabContentOptions & TopTabStripeConfiguration;
interface State {
    /** list of current tabs; one TabContent for each */
    tabs: TabModel[];
    /** Has the first tab activated itself? */
    isFirstTabReady: boolean;
    /** current active tab index */
    activeIdx: number;
}
export default class TabContainer extends React.PureComponent<Props, State> {
    constructor(props: Props);
    /** save tab state such as CWD prior to a tab switch */
    private captureState;
    /** restore tab state after a tab switch */
    private restoreState;
    /**
     * Switch Tab event: update state so that activeIdx=idx
     *
     */
    private onSwitchTab;
    private readonly _onSwitchTab;
    /**
     * Close Tab event
     *
     */
    private onCloseTab;
    private readonly _onCloseTab;
    private listenForTabClose;
    private newTabModel;
    /**
     * New Tab event
     *
     */
    private onNewTab;
    private readonly _onNewTab;
    private graft;
    /** Graft the tab `uuid` */
    private children;
    private willUpdateTopTabButtons;
    private onTabReady;
    private readonly _onTabReady;
    /** Render the row of Tabs along the top */
    private topTabStripe;
    /** Render the content of the tabs */
    private tabContent;
    render(): JSX.Element;
}
export {};
