/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
/** for html pre-rendered dom content */
export default class XtermDom extends React.PureComponent {
    renderRow(cells) {
        if (cells.length === 1) {
            // If we have a single child with no styling, inline its text
            // directly into the row element.
            const cell = cells[0];
            if (cell.classList && cell.classList.length === 0 && cell.style && Object.keys(cell.style).length === 0) {
                return cell.innerText.length === 0 ? '\u00a0' : cell.innerText;
            }
        }
        return cells.map((cell, idx) => {
            const className = cell.classList ? cell.classList.join(' ') : '';
            const style = cell.style || {};
            return (React.createElement("span", { key: idx, className: className, style: style }, cell.innerText));
        });
    }
    render() {
        return this.props.response.rows.length === 0 ? (React.createElement(React.Fragment, null)) : (React.createElement("div", { className: "padding-content scrollable scrollable-auto page-content", style: { display: 'flex', flex: 1 } },
            React.createElement("div", { style: { display: 'flex', flex: 1 } },
                React.createElement("div", { className: "xterm-container xterm-terminated" },
                    React.createElement("div", { className: "xterm-rows" }, this.props.response.rows.map((_, idx) => (React.createElement("div", { key: idx }, this.renderRow(_)))))))));
    }
}
//# sourceMappingURL=XtermDom.js.map