import { Table } from '@kui-shell/core';
export interface Coloring {
    nDurationBuckets(): number;
    durationRangeOfSplit(idx: number): string;
    durationBucket(duration: number): number;
    durationCssForBucket(idx: number): string;
    durationCss(duration: number, isError: boolean): string;
}
declare abstract class AbstractColoring implements Coloring {
    private readonly thresholds;
    protected constructor(thresholds: any);
    nDurationBuckets(): any;
    durationRangeOfSplit(idx: number): string;
    durationCssForBucket(idx: number): string;
    durationBucket(duration: number): any;
    durationCss(duration: number, isError: boolean): string;
}
export declare class FixedColoring extends AbstractColoring {
    constructor();
    durationCssForBucket(idx: number): string;
}
export declare class StdevColoring extends AbstractColoring {
    constructor(datapoints: Table | number[]);
    private static datapointsFrom;
    private static computeThresholdsFrom;
}
export default StdevColoring;
