import React from 'react';
import { REPL, Row, Tab, Table } from '@kui-shell/core';
interface Props {
    response: Table;
    tab: Tab;
    repl: REPL;
    /** whether the table is currently "live", and responding to updates from the controller */
    isWatching: boolean;
}
interface State {
    rows: Row[];
    animate: boolean;
    counts: number[];
    colors: string[];
    scale: 'linear' | 'log';
}
export default class Histogram extends React.PureComponent<Props, State> {
    private static readonly domainPadding;
    private readonly horizontal;
    private readonly barHeight;
    private readonly barSpacing;
    private readonly axisLabelFontSize;
    private readonly minAxisLabelChars;
    private readonly maxAxisLabelChars;
    private readonly barLabelFontSize;
    private readonly minBarLabelChars;
    private readonly maxBarLabelChars;
    private static readonly maxAnimatableRows;
    constructor(props: Props);
    componentDidCatch(error: Error, errorInfo: React.ErrorInfo): void;
    static getDerivedStateFromProps(props: Props, state: State): State | {
        animate: boolean;
    };
    private static filterRows;
    /** heuristic to allow "just enough" space for axis labels */
    private leftPad;
    /** heuristic to allow right space for bar labels */
    private rightPad;
    private rows;
    private axis;
    private static isTiny;
    private bars;
    render(): JSX.Element;
}
export {};
