/// <reference types="react" />
import { Table as KuiTable, Watchable } from '@kui-shell/core';
import PaginatedTable, { Props, State } from './PaginatedTable';
declare type LiveProps = Props<KuiTable & Watchable> & {
    onRender: (hasContent: boolean) => void;
};
interface LiveState extends State {
    isWatching: boolean;
    lastUpdatedMillis: number;
}
export default class LivePaginatedTable extends PaginatedTable<LiveProps, LiveState> {
    /** To allow for batch updates, the setState can be deferred until a call to updateDone() */
    private _deferredUpdate;
    private previouslyReceivedHeader;
    constructor(props: LiveProps);
    /**
     * Only after the dom is attached can we initialize the watcher,
     * because it may otherwise trigger render() calls before we have
     * been attached.
     *
     */
    componentDidMount(): void;
    /** @return whether the table is currently "live", and responding to updates from the controller */
    protected isWatching(): boolean;
    protected dataAttrs(): {
        'data-table-watching': boolean;
        'data-table-as-grid': boolean;
    };
    /** Render the component */
    render(): JSX.Element;
    /**
     * Initialize watcher channel to the provider, and attach the job so
     * that it can be managed w.r.t. UI contexts (such as tabs) coming
     * and going.
     *
     */
    private initWatch;
    private pauseWatch;
    private resumeWatch;
    protected watchControll(): void;
    /** E.g. last updated time for live tables */
    protected caption(): JSX.Element;
    private setBody;
    /**
     * offline takes the rowKey of the row to be deleted and applies this to the table view
     *
     */
    private offline;
    /**
     * allOffline allows pollers to indicate that all resources are not to be found
     *
     */
    private allOffline;
    /**
     * update consumes the update notification and apply it to the table view
     *
     */
    private update;
    /** End of a deferred batch of updates */
    private batchUpdateDone;
    /**
     * Update to reflect new header model
     *
     */
    private header;
    /**
     * Update to reflect new footer message
     *
     */
    private footer;
    /**
     * Done watching!
     *
     */
    private done;
}
export {};
