/// <reference types="react" />
import { Tab, NavResponse } from '@kui-shell/core';
import Width from './width';
import { NavigationModel } from '../../spi/Navigation';
import BaseSidecar, { Props, State } from './BaseSidecarV2';
/**
 *
 * LeftNavSidecar
 * -------------------------
 * | <TitleBar/>           |
 * -------------------------
 * | A1   |                |
 * |  a1  | <Content>      |
 * |  a2  |  <KuiContent/> |
 * | B1   | </Content>     |
 * |  b1  |                |
 * |  b2  |                |
 * -------------------------
 *  ^^^^^ <SideNav/>
 *   A1, B1: <SideNavMenu/>
 *   a1, b1: <SideNavMenuItem/>
 *
 */
export default class LeftNavSidecar extends BaseSidecar<NavResponse, NavigationModel & State> {
    constructor(props: Props<NavResponse>);
    /** 30/70 split between the Terminal and the LeftNavSidecar */
    protected defaultWidth(): Width;
    /** @return State for the given `Response` */
    protected getState(tab: Tab, response: NavResponse): NavigationModel & State;
    private changeCurrent;
    private readonly _onChange;
    /** render the leftnav part */
    protected nav(): JSX.Element;
    protected bodyContent(tabIdx: number, menuIdx?: number): JSX.Element;
    protected bodyContainer(tabIdx: number, menuIdx: number): JSX.Element;
    render(): JSX.Element;
}
