import React from 'react';
import { HistoryModel } from '@kui-shell/core';
import Input from './Input';
/** state of the reverse-i-search */
export default class ActiveISearch {
    private readonly input;
    private readonly history;
    private readonly currentSearchIdx;
    private readonly reachedTheEnd;
    constructor(input: Input, history: HistoryModel, currentSearchIdx?: number, reachedTheEnd?: boolean);
    private fixedPart;
    private matchedPrefixPart;
    private matchedSuffixPart;
    private typedPart;
    private matchAt;
    currentMatch(): string;
    render(): JSX.Element;
    /**
     * For various reasons, user has cancelled a reverse-i-search.
     *
     */
    cancelISearch(): void;
    /**
     * Search command history for a match, skipping over identicals.
     *
     * @param startIdx start searching backwards from here
     * @param userHitCtrlR is this a request to find another match further in the past?
     *
     * @return a command history index, or -1 if not match is found
     *
     */
    private findPrevious;
    /**
     * Attempt to initiate or extend a search
     *
     */
    doSearch(evt: React.KeyboardEvent): void;
    /** fill in the result of a search */
    completeSearch(): void;
}
/**
 * Listen for ctrl+R
 *
 */
export declare function onKeyUp(this: Input, evt: React.KeyboardEvent): Promise<void>;
