/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
export default class FancyPipeline extends React.PureComponent {
    linebreak() {
        return React.createElement("span", { className: "kui--line-break" }, "\u00A0");
    }
    pipe(c) {
        return React.createElement("strong", { className: "pre-wrap left-pad sub-text" },
            c,
            " ");
    }
    /**
     * Pretty-print the command line with `pipeStages`
     * e.g. somePrefix -- foo | bar > baz
     */
    render() {
        const { prefix, stages, redirect, REPL } = this.props;
        return (React.createElement("span", { className: "repl-input-element flex-fill" },
            prefix && (React.createElement(React.Fragment, null,
                React.createElement("span", { className: "pre-wrap" },
                    prefix,
                    " -- "),
                (stages.length > 0 || redirect) && (React.createElement(React.Fragment, null,
                    this.linebreak(),
                    this.pipe('\u00a0'))))),
            stages.map((pipePart, pidx, parts) => (React.createElement(React.Fragment, { key: pidx },
                pidx > 0 && this.pipe('|'),
                pipePart.map((word, widx) => widx === 0 ? (React.createElement("span", { key: widx, className: "color-base0D" }, word)) : (` ${word}`)),
                pidx < parts.length - 1 && this.linebreak()))),
            redirect && (React.createElement(React.Fragment, null,
                this.linebreak(),
                this.pipe('>'),
                React.createElement("span", { className: "clickable", onClick: () => REPL.pexec(`ls ${redirect}`) }, redirect)))));
    }
}
//# sourceMappingURL=FancyPipeline.js.map