import React from 'react';
import { Tab as KuiTab } from '@kui-shell/core';
import { InputOptions } from './Input';
import { BlockModel } from './BlockModel';
export declare type BlockViewTraits = {
    /** number of splits currently in this tab */
    nSplits?: number;
    isExperimental?: boolean;
    isFocused?: boolean;
    isPartOfMiniSplit?: boolean;
    isWidthConstrained?: boolean;
    /** Handler for: User clicked to focus on this block */
    willFocusBlock?: (evt: React.SyntheticEvent) => void;
    /** Handler for <li> focus */
    onFocus?: (evt: React.FocusEvent) => void;
};
export interface BlockOperationTraits {
    /** Remove the enclosing block */
    willRemove?: (evt: React.SyntheticEvent, idx?: number) => void;
}
declare type Props = InputOptions & {
    /** block ordinal index */
    idx: number;
    /** block ordinal index to be displayed to the user */
    displayedIdx?: number;
    /** block model */
    model: BlockModel;
    /** Are we in the middle of a re-run? */
    isBeingRerun?: boolean;
    /** tab UUID */
    uuid: string;
    /** tab model */
    tab: KuiTab;
    noActiveInput?: boolean;
    /** Is this block the one currently displayed in a MiniSplit */
    isVisibleInMiniSplit?: boolean;
    noOutput?: boolean;
    onOutputRender?: () => void;
    willUpdateCommand?: (idx: number, command: string) => void;
} & BlockViewTraits;
interface State {
    _block?: HTMLElement;
    /** Is the Input element focused? */
    isFocused: boolean;
    /** Does a child want to us to be maximized? */
    isMaximized: boolean;
}
export default class Block extends React.PureComponent<Props, State> {
    /** grab a ref to the Input to help with maintaining focus */
    private _input;
    constructor(props: Props);
    /** Owner wants us to focus on the current prompt */
    doFocus(): void;
    inputValue(): string;
    /** Child wants to maximize/restore */
    private willChangeSize;
    private readonly _willChangeSize;
    private onOutputRender;
    private readonly _onOutputRender;
    private output;
    private willScreenshot;
    private customInput;
    private input;
    /**
     * For Active or Empty blocks, just show the <Input/>, otherwise
     * wrap the <Input/>-<Output/> pair.
     *
     */
    render(): JSX.Element;
}
export {};
