/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import React from 'react';
import { i18n } from '@kui-shell/core';
import Icons from '../../spi/Icons';
import Tooltip from '../../spi/Tooltip';
import '../../../../web/scss/components/Terminal/SplitHeader.scss';
const strings = i18n('plugin-client-common');
/** Render a header for the given split */
export default class SplitHeader extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.stopFocusStealing = (evt) => evt.preventDefault();
    }
    closeButton() {
        return (React.createElement(Tooltip, { markdown: strings('Close this split pane') },
            React.createElement("a", { href: "#", className: "kui--split-close-button kui--tab-navigatable", onMouseDown: this.stopFocusStealing, onClick: this.props.onRemove }, "\u2A2F")));
    }
    clearButton() {
        return (React.createElement(Tooltip, { markdown: strings('Clear this split pane') },
            React.createElement("a", { href: "#", className: "kui--tab-navigatable", onMouseDown: this.stopFocusStealing, onClick: this.props.onClear },
                React.createElement(Icons, { className: "kui--split-clear-button", icon: "Clear" }))));
    }
    render() {
        return (React.createElement("div", { className: "kui--split-header flex-layout kui--inverted-color-context" },
            React.createElement("div", { className: "flex-fill" }),
            this.clearButton(),
            this.closeButton()));
    }
}
//# sourceMappingURL=SplitHeader.js.map