import { ReactNode } from 'react';
import { REPL } from '@kui-shell/core';
import { DropDownAction } from '../DropDown';
interface Props {
    /** Place the given header node at the top of the Card */
    header?: ReactNode;
    /** Place the given footer node at the bottom of the Card */
    footer?: ReactNode;
    /** Content rendered inside the CardTitle */
    title?: string;
    /** Place the given icon image at the top of the Card */
    icon?: string;
    /** Body of the Card. If given a string, it will be passed through as the source <Markdown source="..." /> */
    children: string | ReactNode;
    /** Base HTTP Url? */
    baseUrl?: string;
    titleInHeader?: boolean;
    /** [Optional] Display body in header? */
    bodyInHeader?: boolean;
    /** [Optional] Overflow menu actions; rendered in the upper right corner */
    actions?: DropDownAction[];
    /** [Optional] Options to be rendered in the upper right corner (not in an overflow menu) */
    inlineActions?: ReactNode[];
    /** [Optional] CSS class to associate with the outermost Card element */
    className?: string;
    /** [Optional] CSS class to associate with the Card footer */
    footerClassName?: string;
    /** [Optional] REPL controller, but required if you want your Card
     * to have functional kuiexec?command=... links via Markdown */
    repl?: REPL;
    /** [Optional] Card onClick handler */
    onCardClick?: (evt: React.MouseEvent) => void;
}
export default Props;
