"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _core = require("@kui-shell/core");

var _echo = _interopRequireDefault(require("./lib/cmds/echo"));

var _quit = _interopRequireDefault(require("./lib/cmds/quit"));

var _clear = _interopRequireDefault(require("./lib/cmds/clear"));

var _dopar = _interopRequireDefault(require("./lib/cmds/dopar"));

var _watch = _interopRequireDefault(require("./lib/cmds/watch"));

var _base = _interopRequireDefault(require("./lib/cmds/base64"));

var _prompt = _interopRequireDefault(require("./lib/cmds/prompt"));

var _replay = _interopRequireDefault(require("./lib/cmds/replay"));

var _sleep = _interopRequireDefault(require("./lib/cmds/sleep"));

var _history = _interopRequireDefault(require("./lib/cmds/history/history"));

var _kuiConfig = _interopRequireDefault(require("./lib/cmds/kui-config"));

var _tabManagement = _interopRequireDefault(require("./lib/cmds/tab-management"));

var _grammy = _interopRequireDefault(require("./lib/cmds/grammy"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

// import updater from './lib/admin/updater'

/**
 * This is the module
 *
 */
var _default = commandTree => __awaiter(void 0, void 0, void 0, function* () {
  yield Promise.all([// help(commandTree, options),
  (0, _echo.default)(commandTree), (0, _quit.default)(commandTree), (0, _clear.default)(commandTree), commandTree.listen('/dopar', _dopar.default), (0, _watch.default)(commandTree), (0, _base.default)(commandTree), (0, _prompt.default)(commandTree), (0, _replay.default)(commandTree), (0, _sleep.default)(commandTree), (0, _history.default)(commandTree), (0, _kuiConfig.default)(commandTree), (0, _grammy.default)(commandTree), (0, _tabManagement.default)(commandTree)]);

  if (!(0, _core.isHeadless)()) {
    yield Promise.all([Promise.resolve().then(() => require('./lib/cmds/zoom')).then(_ => _.plugin(commandTree)), Promise.resolve().then(() => require('./lib/cmds/theme')).then(_ => _.plugin(commandTree))]);
  } // updater(commandTree) <-- disabled for now

});

exports.default = _default;