import { ButtonProps, FormProps } from '@patternfly/react-core';
import React, { ReactNode } from 'react';
export interface IValidationData {
    /** Flag indicating if controls should validate their input */
    readonly validate: boolean;
    /** Mapping of control ids to error strings */
    readonly errors: {
        [id: string]: string | undefined;
    };
    /** Flag indicating if controls should be read only */
    readonly isReadOnly: boolean;
}
export interface IValidationState extends IValidationData {
    setValidate: (validate: boolean) => void;
    setError: (id: string, error?: string) => void;
    setReadOnly: (disabled: boolean) => void;
}
export declare function hasValidationErrors(state: IValidationData): boolean;
export declare const ValidationContext: React.Context<IValidationState>;
export declare function useValidationState(): IValidationState;
export declare function AcmValidationProvider(props: {
    children: ReactNode;
}): JSX.Element;
export declare function useValidationContext(): IValidationState;
export declare function AcmForm(props: FormProps): JSX.Element;
declare type AcmSubmitProps = ButtonProps & {
    label?: string;
    processingLabel?: string;
};
export declare function AcmSubmit(props: AcmSubmitProps): JSX.Element;
/** @deprecated Deprecated - use ValidationContext instead */
export declare const FormContext: React.Context<IValidationState>;
/** @deprecated Deprecated - use AcmValidationProvider instead */
export declare const AcmFormProvider: typeof AcmValidationProvider;
export {};
