"use strict";
/* Copyright Contributors to the Open Cluster Management project */
/* eslint-disable @typescript-eslint/no-non-null-assertion */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compareNumbers = exports.compareStrings = exports.compareUnknowns = exports.compareItems = exports.AcmTable = exports.AcmTablePaginationContextProvider = void 0;
var styles_1 = require("@material-ui/styles");
var react_core_1 = require("@patternfly/react-core");
var caret_down_icon_1 = __importDefault(require("@patternfly/react-icons/dist/js/icons/caret-down-icon"));
var react_table_1 = require("@patternfly/react-table");
var resize_observer_1 = __importDefault(require("@react-hook/resize-observer"));
var fuse_js_1 = __importDefault(require("fuse.js"));
var get_value_1 = __importDefault(require("get-value"));
var react_1 = __importStar(require("react"));
var AcmButton_1 = require("../AcmButton/AcmButton");
var AcmEmptyState_1 = require("../AcmEmptyState/AcmEmptyState");
var useStyles = styles_1.makeStyles({
    tableDiv: {
        display: 'table',
        width: '100%',
    },
    outerDiv: {
        display: 'block',
    },
    table: {
        '& tbody.pf-m-expanded > tr': {
            borderBottom: 0,
            overflowY: 'visible !important',
            '& .pf-c-table__expandable-row-content': {
                paddingTop: 0,
                paddingBottom: 0,
            },
            '&:first-of-type, &:last-of-type': {
                borderBottom: 'var(--pf-c-table--border-width--base) solid var(--pf-c-table--BorderColor)',
            },
        },
    },
});
function countGroups(items) {
    var _a = items.reduce(function (acc, item) {
        if (item.group) {
            acc.groups.add(item.group);
        }
        else {
            acc.ungrouped++;
        }
        return acc;
    }, { ungrouped: 0, groups: new Set() }), ungrouped = _a.ungrouped, groups = _a.groups;
    return ungrouped + groups.size;
}
function OuiaIdRowWrapper(props) {
    return react_1.default.createElement(react_table_1.RowWrapper, __assign({}, props, { ouiaId: get_value_1.default(props, 'row.props.key') }));
}
var DEFAULT_ITEMS_PER_PAGE = 10;
var BREAKPOINT_SIZES = [
    { name: react_table_1.TableGridBreakpoint.none, size: 0 },
    { name: react_table_1.TableGridBreakpoint.gridMd, size: 768 },
    { name: react_table_1.TableGridBreakpoint.gridLg, size: 992 },
    { name: react_table_1.TableGridBreakpoint.gridXl, size: 1200 },
    { name: react_table_1.TableGridBreakpoint.grid2xl, size: 1450 },
    { name: react_table_1.TableGridBreakpoint.grid, size: Infinity },
];
var AcmTablePaginationContext = react_1.createContext({});
function AcmTablePaginationContextProvider(props) {
    var children = props.children, localStorageKey = props.localStorageKey;
    var _a = react_1.useState(parseInt(localStorage.getItem(localStorageKey) || '0', 10) || DEFAULT_ITEMS_PER_PAGE), perPage = _a[0], setPerPage = _a[1];
    var paginationContext = {
        perPage: perPage,
        setPerPage: function (perPage) {
            localStorage.setItem(localStorageKey, String(perPage));
            setPerPage(perPage);
        },
    };
    return react_1.default.createElement(AcmTablePaginationContext.Provider, { value: paginationContext }, children);
}
exports.AcmTablePaginationContextProvider = AcmTablePaginationContextProvider;
function AcmTable(props) {
    var _a, _b;
    var items = props.items, columns = props.columns, addSubRows = props.addSubRows, keyFn = props.keyFn, groupFn = props.groupFn, groupSummaryFn = props.groupSummaryFn, _c = props.bulkActions, bulkActions = _c === void 0 ? [] : _c, _d = props.rowActions, rowActions = _d === void 0 ? [] : _d, rowActionResolver = props.rowActionResolver, _e = props.tableActions, tableActions = _e === void 0 ? [] : _e;
    var defaultSort = {
        index: 0,
        direction: react_table_1.SortByDirection.asc,
    };
    var initialSort = props.initialSort || defaultSort;
    // State that is only stored in the component state
    var _f = react_1.useState({}), selected = _f[0], setSelected = _f[1];
    var _g = react_1.useState(false), actionsOpen = _g[0], setActionsOpen = _g[1];
    var _h = react_1.useState(initialSort), preFilterSort = _h[0], setPreFilterSort = _h[1];
    var _j = react_1.useState({}), expanded = _j[0], setExpanded = _j[1];
    var _k = react_1.useState({}), openGroups = _k[0], setOpenGroups = _k[1];
    // State that can come from context or component state (perPage)
    var _l = react_1.useState(DEFAULT_ITEMS_PER_PAGE), statePerPage = _l[0], stateSetPerPage = _l[1];
    var _m = react_1.useContext(AcmTablePaginationContext), contextPerPage = _m.perPage, contextSetPerPage = _m.setPerPage;
    var perPage = contextPerPage || statePerPage;
    var setPerPage = contextSetPerPage || stateSetPerPage;
    // State that can be controlled from component props or uncontrolled from component state (page, search, sort)
    var _o = react_1.useState(1), statePage = _o[0], stateSetPage = _o[1];
    var page = props.page || statePage;
    var setPage = props.setPage || stateSetPage;
    var _p = react_1.useState(''), stateSearch = _p[0], stateSetSearch = _p[1];
    var search = props.search || stateSearch;
    var setSearch = props.setSearch || stateSetSearch;
    var searchPlaceholder = props.searchPlaceholder || 'Search';
    var _q = react_1.useState(initialSort), stateSort = _q[0], stateSetSort = _q[1];
    var sort = props.sort || stateSort;
    var setSort = props.setSort || stateSetSort;
    // Dynamic gridBreakPoint
    var _r = react_1.useState(react_table_1.TableGridBreakpoint.none), breakpoint = _r[0], setBreakpoint = _r[1];
    var _s = react_1.useState(), exactBreakpoint = _s[0], setExactBreakpoint = _s[1];
    var _t = react_1.useState(null), outerDiv = _t[0], setOuterDiv = _t[1];
    var _u = react_1.useState(null), tableDiv = _u[0], setTableDiv = _u[1];
    var outerDivRef = react_1.useCallback(function (elem) { return setOuterDiv(elem); }, []);
    var tableDivRef = react_1.useCallback(function (elem) { return setTableDiv(elem); }, []);
    /* istanbul ignore next */
    var updateBreakpoint = function (width, tableWidth) {
        var _a, _b;
        var viewportWidth = window.innerWidth;
        if (tableWidth > width) {
            // table needs to switch to cards; make the change and record viewport size when this happened
            var newBreakpoint = ((_a = BREAKPOINT_SIZES.find(function (b) { return viewportWidth <= b.size; })) === null || _a === void 0 ? void 0 : _a.name) || react_table_1.TableGridBreakpoint.none;
            setBreakpoint(newBreakpoint);
            setExactBreakpoint(width);
        }
        else if (exactBreakpoint && width > exactBreakpoint) {
            // outerDiv is now bigger than when we last switched to cards; try bigger breakpoint, which will
            // be reverted in the layout effect if the table view is still too wide
            var newBreakpoint = ((_b = __spreadArray([], BREAKPOINT_SIZES).reverse().find(function (b) { return viewportWidth > b.size; })) === null || _b === void 0 ? void 0 : _b.name) || react_table_1.TableGridBreakpoint.grid;
            setBreakpoint(newBreakpoint);
        }
    };
    react_1.useLayoutEffect(function () {
        if (!props.gridBreakPoint && outerDiv && tableDiv) {
            updateBreakpoint(outerDiv.clientWidth, tableDiv.clientWidth);
        }
    }, 
    // Check breakpoints as soon as ref callbacks are set, in case initial viewport is too small for table
    // Need to check on every update to breakpoint as well for the same case, so that display
    // doesn't thrash between table/cards on initial expansion of viewport
    [breakpoint, outerDiv, tableDiv]);
    /* istanbul ignore next */
    resize_observer_1.default(outerDiv, function () {
        if (!props.gridBreakPoint && outerDiv && tableDiv) {
            var width = outerDiv.clientWidth;
            var tableWidth = tableDiv.clientWidth;
            updateBreakpoint(width, tableWidth);
        }
    });
    var classes = useStyles();
    react_1.useEffect(function () {
        var _a;
        /* istanbul ignore else */
        if ((_a = props.initialSelectedItems) === null || _a === void 0 ? void 0 : _a.length) {
            var initialSelected_1 = {};
            props.initialSelectedItems.forEach(function (item) {
                var key = keyFn(item);
                initialSelected_1[key] = true;
            });
            setSelected(initialSelected_1);
        }
    }, [props.initialSelectedItems]);
    react_1.useLayoutEffect(function () {
        var newSelected = {};
        /* istanbul ignore next */
        Object.keys(selected)
            .filter(function (key) { var _a; return (_a = props.items) === null || _a === void 0 ? void 0 : _a.find(function (item) { return keyFn(item) === key; }); })
            .forEach(function (key) {
            newSelected[key] = selected[key];
        });
        setSelected(newSelected);
    }, [items]);
    var _v = react_1.useMemo(function () {
        /* istanbul ignore if */
        if (!items)
            return { tableItems: [], totalCount: 0 };
        var tableItems = items.map(function (item) {
            var key = keyFn(item);
            var group = (groupFn && groupFn(item)) || undefined;
            var subRows = addSubRows === null || addSubRows === void 0 ? void 0 : addSubRows(item);
            var tableItem = { item: item, subRows: subRows, key: key, group: group };
            for (var i = 0; i < columns.length; i++) {
                var column = columns[i];
                if (column.search) {
                    if (typeof column.search === 'string') {
                        tableItem["column-" + i] = get_value_1.default(item, column.search);
                    }
                    else {
                        tableItem["column-" + i] = column.search(item);
                    }
                }
            }
            return tableItem;
        });
        return { tableItems: tableItems, totalCount: groupFn ? countGroups(tableItems) : tableItems.length };
    }, [items, columns, addSubRows, keyFn, groupFn]), tableItems = _v.tableItems, totalCount = _v.totalCount;
    var _w = react_1.useMemo(function () {
        var threshold = 0.3;
        if (props.fuseThreshold != undefined) {
            threshold = props.fuseThreshold;
        }
        if (search && search !== '') {
            var fuse = new fuse_js_1.default(tableItems, {
                ignoreLocation: true,
                threshold: threshold,
                keys: columns
                    .map(function (column, i) { return (column.search ? "column-" + i : undefined); })
                    .filter(function (value) { return value !== undefined; }),
                // TODO use FuseOptionKeyObject to allow for weights
            });
            var filtered_1 = fuse.search(search).map(function (result) { return result.item; });
            return { filtered: filtered_1, filteredCount: groupFn ? countGroups(filtered_1) : filtered_1.length };
        }
        else {
            return { filtered: tableItems, filteredCount: totalCount };
        }
    }, [search, items, tableItems, totalCount, columns, groupFn]), filtered = _w.filtered, filteredCount = _w.filteredCount;
    var sorted = react_1.useMemo(function () {
        if (sort && sort.index !== undefined) {
            var compare_1 = columns[sort.index].sort;
            var sorted_1 = __spreadArray([], filtered);
            /* istanbul ignore else */
            if (compare_1) {
                if (typeof compare_1 === 'string') {
                    sorted_1.sort(compareItems("item." + compare_1));
                }
                else {
                    sorted_1.sort(function (a, b) { return compare_1(a.item, b.item); });
                }
            }
            if (sort.direction === react_table_1.SortByDirection.desc) {
                sorted_1.reverse();
            }
            return sorted_1;
        }
        else {
            return filtered;
        }
    }, [filtered, sort, columns]);
    var _x = react_1.useMemo(function () {
        if (groupFn) {
            var grouped_1 = [];
            var groupSubItems_1 = {};
            sorted.forEach(function (tableItem) {
                var group = tableItem.group, item = tableItem.item;
                if (group) {
                    tableItem.subItems = [];
                    if (!groupSubItems_1[group]) {
                        groupSubItems_1[group] = tableItem.subItems;
                        grouped_1.push(tableItem);
                    }
                    else {
                        groupSubItems_1[group].push(item);
                    }
                }
                else {
                    grouped_1.push(tableItem);
                }
            });
            return { grouped: grouped_1, itemCount: grouped_1.length };
        }
        else {
            return { grouped: sorted, itemCount: sorted.length };
        }
    }, [sorted, columns, groupFn]), grouped = _x.grouped, itemCount = _x.itemCount;
    var paged = react_1.useMemo(function () {
        var start = (page - 1) * perPage;
        var actualPage = page;
        if (start > grouped.length) {
            actualPage = Math.floor(grouped.length / perPage) + 1;
            start = (actualPage - 1) * perPage;
            setPage(actualPage);
        }
        return grouped.slice(start, start + perPage);
    }, [grouped, page, perPage]);
    var _y = react_1.useMemo(function () {
        var newRows = [];
        var itemToCells = function (item, key) {
            return columns.map(function (column) {
                return typeof column.cell === 'string'
                    ? get_value_1.default(item, column.cell)
                    : { title: react_1.default.createElement(react_1.Fragment, { key: key }, column.cell(item)) };
            });
        };
        var addedSubRowCount = 0;
        paged.forEach(function (tableItem, i) {
            var _a;
            var item = tableItem.item, key = tableItem.key, group = tableItem.group, subItems = tableItem.subItems, subRows = tableItem.subRows;
            var isOpen = undefined;
            if (group) {
                // Only expandable if the next item is also part of the group
                if (subItems.length) {
                    isOpen = !!openGroups[group];
                }
            }
            else {
                isOpen = (_a = expanded[key]) !== null && _a !== void 0 ? _a : ((subRows === null || subRows === void 0 ? void 0 : subRows.length) ? false : undefined);
            }
            // if there will be a group summary, include first item with the sub items
            var allSubItems = (group && groupSummaryFn && subItems && subItems.length && [item].concat(subItems)) || subItems;
            if (group && groupSummaryFn && allSubItems) {
                // if there are no sub items, pass in single item
                var groupSummary = groupSummaryFn(allSubItems.length ? allSubItems : [item]);
                newRows.push(__assign(__assign({}, groupSummary), { isOpen: isOpen, selected: selected[key] === true, props: { key: group, group: group } }));
            }
            else {
                newRows.push({
                    isOpen: isOpen,
                    selected: selected[key] === true,
                    props: { key: key, group: group },
                    cells: itemToCells(item, key),
                });
            }
            if (allSubItems) {
                allSubItems.forEach(function (item) {
                    var key = keyFn(item);
                    newRows.push({
                        parent: i + addedSubRowCount,
                        props: { key: key },
                        cells: itemToCells(item, key),
                    });
                });
                addedSubRowCount += allSubItems.length;
            }
            else if (subRows) {
                subRows.forEach(function (subRow) { return newRows.push(__assign(__assign({}, subRow), { parent: i + addedSubRowCount })); });
                addedSubRowCount += subRows.length;
            }
        });
        return { rows: newRows, addedSubRowCount: addedSubRowCount };
    }, [selected, paged, columns, expanded, openGroups, keyFn]), rows = _y.rows, addedSubRowCount = _y.addedSubRowCount;
    var onCollapse = react_1.useMemo(function () {
        if (groupFn && addedSubRowCount) {
            return function (_event, rowIndex, isOpen) {
                var _a;
                var rowKey = rows[rowIndex].props.group.toString();
                setOpenGroups(__assign(__assign({}, openGroups), (_a = {}, _a[rowKey] = isOpen, _a)));
            };
        }
        else if (addSubRows && addedSubRowCount) {
            return function (_event, rowIndex, isOpen) {
                var _a;
                var rowKey = rows[rowIndex].props.key.toString();
                setExpanded(__assign(__assign({}, expanded), (_a = {}, _a[rowKey] = isOpen, _a)));
            };
        }
        return undefined;
    }, [rows, addedSubRowCount, openGroups, setOpenGroups, expanded, setExpanded, groupFn, addSubRows]);
    // Compensate for PF auto-added columns
    // sort state always contains the data index
    // adjustedSort and the updateSort callback compensate for header display index used in PF
    var adjustedSortIndexOffset = (bulkActions && bulkActions.length ? 1 : 0) + (onCollapse ? 1 : 0);
    var adjustedSort = sort && sort.index !== undefined && sort.index !== null && sort.direction && filtered.length > 0
        ? {
            index: sort.index + adjustedSortIndexOffset,
            direction: sort.direction,
        }
        : sort;
    var updateSearch = react_1.useCallback(function (newSearch) {
        setSearch(newSearch);
        setPage(1);
        if (!newSearch) {
            // clearing filtered state; restore previous sorting if applicable
            if (preFilterSort) {
                setSort(preFilterSort);
            }
        }
        else if (!search) {
            // entering a filtered state; save sort setting use fuzzy match sort
            setPreFilterSort(sort);
            setSort(undefined);
        }
    }, 
    // setSort/setSearch/setPage can come from props, but setPreFilterSort is only from state and therefore
    // guaranteed stable - not needed in dependency list
    [search, sort, preFilterSort, setSort, setSearch, setPage]);
    var updateSort = react_1.useCallback(function (newSort) {
        if (filtered.length === 0) {
            setSort(newSort);
        }
        else {
            setSort({
                index: (newSort && newSort.index ? newSort.index : 0) - adjustedSortIndexOffset,
                direction: newSort && newSort.direction,
            });
        }
        if (search) {
            // sort changed while filtering; forget previous setting
            setPreFilterSort(undefined);
        }
    }, [search, filtered, adjustedSortIndexOffset]);
    var updatePerPage = react_1.useCallback(function (newPerPage) {
        // keep the first item in view on pagination size change
        var newPage = Math.floor(((page - 1) * perPage) / newPerPage) + 1;
        setPage(newPage);
        setPerPage(newPerPage);
    }, [page, perPage, setPage, setPerPage]);
    var onSelect = react_1.useCallback(function (_event, isSelected, rowId) {
        if (rowId === -1) {
            var allSelected = true;
            for (var _i = 0, rows_1 = rows; _i < rows_1.length; _i++) {
                var row = rows_1[_i];
                if (!row.selected && row.parent === undefined) {
                    allSelected = false;
                    break;
                }
            }
            var newSelected_1 = {};
            /* istanbul ignore else */
            if (!allSelected) {
                for (var _a = 0, filtered_2 = filtered; _a < filtered_2.length; _a++) {
                    var tableItem = filtered_2[_a];
                    newSelected_1[tableItem.key] = true;
                }
            }
            setSelected(newSelected_1);
            /* istanbul ignore next */
            if (props.onSelect && items) {
                props.onSelect(items.filter(function (item) { return newSelected_1[keyFn(item)]; }));
            }
        }
        else {
            var newSelected_2 = __assign({}, selected);
            if (isSelected) {
                newSelected_2[rows[rowId].props.key] = true;
            }
            else {
                delete newSelected_2[rows[rowId].props.key];
            }
            setSelected(newSelected_2);
            /* istanbul ignore next */
            if (props.onSelect && items) {
                props.onSelect(items.filter(function (item) { return newSelected_2[keyFn(item)]; }));
            }
        }
    }, [filtered, rows, keyFn]);
    // Function to parse provided actions from AcmTable IAcmRowAction --> Patternfly Table IAction
    var parseRowAction = function (rowActions) {
        var actions = [];
        rowActions.forEach(function (action) {
            // Add separator if specified
            if (action.addSeparator) {
                actions.push({
                    isSeparator: true,
                });
            }
            // Add row action with tooltip
            if (action.tooltip) {
                actions.push({
                    title: (react_1.default.createElement(react_core_1.Tooltip, { content: action.tooltip, zIndex: 10001, position: 'left' },
                        react_1.default.createElement(AcmButton_1.AcmButton, { isDisabled: action.isDisabled, variant: react_core_1.ButtonVariant.plain, isInline: true, className: 'tooltiped-action-wrapper', style: {
                                padding: 0,
                                cursor: action.isDisabled ? 'not-allowed' : 'pointer',
                            } }, action.title))),
                    onClick: action.isDisabled
                        ? undefined
                        : function (_event, rowId, rowData) {
                            var _a;
                            if (groupFn || addSubRows) {
                                var tableItem = ((_a = rowData.props) === null || _a === void 0 ? void 0 : _a.key) &&
                                    paged.find(function (tableItem) { return tableItem.key === rowData.props.key; });
                                if (tableItem) {
                                    action.click(tableItem.item);
                                }
                            }
                            else {
                                action.click(paged[rowId].item);
                            }
                        },
                });
            }
            else {
                // Add generic row action
                actions.push({
                    title: action.title,
                    isDisabled: action.isDisabled ? true : false,
                    onClick: function (_event, rowId, rowData) {
                        var _a;
                        if (groupFn || addSubRows) {
                            var tableItem = ((_a = rowData.props) === null || _a === void 0 ? void 0 : _a.key) && filtered.find(function (tableItem) { return tableItem.key === rowData.props.key; });
                            if (tableItem) {
                                action.click(tableItem.item);
                            }
                        }
                        else {
                            action.click(paged[rowId].item);
                        }
                    },
                });
            }
        });
        return actions;
    };
    // Parse static actions
    var actions = parseRowAction(rowActions);
    // Wrap provided action resolver
    var actionResolver;
    if (rowActionResolver) {
        actionResolver = function (rowData, extraData) {
            var _a;
            var tableItem;
            if (groupFn || addSubRows) {
                tableItem = ((_a = rowData.props) === null || _a === void 0 ? void 0 : _a.key) && filtered.find(function (tableItem) { return tableItem.key === rowData.props.key; });
            }
            else {
                tableItem = paged[extraData.rowIndex];
            }
            if (tableItem) {
                return parseRowAction(rowActionResolver(tableItem.item));
            }
            return [];
        };
    }
    var hasSearch = react_1.useMemo(function () { return columns.some(function (column) { return column.search; }); }, [columns]);
    var hasItems = items && items.length > 0 && filtered;
    var showToolbar = props.showToolbar !== false ? hasItems : false;
    var topToolbarStyle = items ? {} : { paddingBottom: 0 };
    return (react_1.default.createElement(react_1.Fragment, null,
        props.extraToolbarControls && (react_1.default.createElement(react_core_1.Toolbar, { style: topToolbarStyle },
            react_1.default.createElement(react_core_1.ToolbarContent, null,
                react_1.default.createElement(react_core_1.ToolbarGroup, { alignment: { default: 'alignRight' } },
                    react_1.default.createElement(react_core_1.ToolbarItem, null, props.extraToolbarControls))))),
        showToolbar && (react_1.default.createElement(react_core_1.Toolbar, null,
            react_1.default.createElement(react_core_1.ToolbarContent, null,
                hasSearch && (react_1.default.createElement(react_core_1.ToolbarGroup, { variant: "filter-group" },
                    react_1.default.createElement(react_core_1.ToolbarItem, { variant: "search-filter" },
                        react_1.default.createElement(react_core_1.SearchInput, { placeholder: searchPlaceholder, value: search, onChange: updateSearch, onClear: function () { return updateSearch(''); }, resultsCount: filteredCount + " / " + totalCount, style: { flexGrow: 1 } })))),
                tableActions.length > 0 && (react_1.default.createElement(react_core_1.ToolbarGroup, { variant: "button-group" }, tableActions.map(function (action) { return (react_1.default.createElement(react_core_1.ToolbarItem, { key: action.id },
                    react_1.default.createElement(AcmButton_1.AcmButton, { onClick: action.click, isDisabled: action.isDisabled, tooltip: action.tooltip, variant: action.variant || react_core_1.ButtonVariant.primary }, action.title))); }))),
                Object.keys(selected).length > 0 && bulkActions.length > 0 && (react_1.default.createElement(react_core_1.ToolbarGroup, { variant: "button-group" },
                    react_1.default.createElement(react_core_1.ToolbarItem, null,
                        react_1.default.createElement(react_core_1.Dropdown
                        // onSelect={this.onSelect}
                        , { 
                            // onSelect={this.onSelect}
                            toggle: react_1.default.createElement(react_core_1.DropdownToggle, { id: "toggle-id", onToggle: function () { return setActionsOpen(!actionsOpen); }, toggleIndicator: caret_down_icon_1.default }, "Actions"), isOpen: actionsOpen, dropdownItems: bulkActions.map(function (action) { return (react_1.default.createElement(react_core_1.DropdownItem, { key: action.id, onClick: function () {
                                    return action.click(items.filter(function (item) { return selected[keyFn(item)]; }));
                                }, isDisabled: action.isDisabled || Object.keys(selected).length === 0, tooltip: action.tooltip }, action.title)); }) })))),
                Object.keys(selected).length > 0 && (react_1.default.createElement(react_core_1.ToolbarGroup, { variant: "button-group" },
                    react_1.default.createElement(react_core_1.ToolbarItem, null, Object.keys(selected).length + " selected"))),
                (!props.autoHidePagination || filtered.length > perPage) && (react_1.default.createElement(react_core_1.ToolbarItem, { variant: "pagination" },
                    react_1.default.createElement(react_core_1.Pagination, { itemCount: itemCount, perPage: perPage, page: page, variant: react_core_1.PaginationVariant.top, onSetPage: function (_event, page) { return setPage(page); }, onPerPageSelect: function (_event, perPage) { return updatePerPage(perPage); }, "aria-label": "Pagination top", isCompact: true })))))),
        !items || !rows || !filtered || !paged ? (react_1.default.createElement(react_core_1.PageSection, { variant: "light", padding: { default: 'noPadding' } },
            react_1.default.createElement(react_core_1.EmptyState, null,
                react_1.default.createElement(react_core_1.EmptyStateIcon, { variant: "container", component: react_core_1.Spinner }),
                react_1.default.createElement(react_core_1.Title, { size: "lg", headingLevel: "h4" }, "Loading")))) : items.length === 0 ? (react_1.default.createElement(react_core_1.PageSection, { variant: props.extraToolbarControls ? 'light' : 'default', padding: { default: 'noPadding' } }, (_a = props.emptyState) !== null && _a !== void 0 ? _a : (react_1.default.createElement(AcmEmptyState_1.AcmEmptyState, { title: "No " + props.plural + " found", message: "You do not have any " + props.plural + " yet." })))) : (react_1.default.createElement(react_1.Fragment, null,
            react_1.default.createElement("div", { ref: outerDivRef, className: classes.outerDiv },
                react_1.default.createElement("div", { ref: tableDivRef, className: classes.tableDiv },
                    react_1.default.createElement(react_table_1.Table, { className: classes.table, cells: columns.map(function (column) {
                            return {
                                title: column.header,
                                header: column.tooltip
                                    ? {
                                        info: {
                                            tooltip: column.tooltip,
                                            tooltipProps: { isContentLeftAligned: true },
                                        },
                                    }
                                    : {},
                                transforms: __spreadArray(__spreadArray([
                                    react_table_1.nowrap
                                ], (column.transforms || [])), (column.sort ? [react_table_1.sortable] : [])),
                                cellTransforms: column.cellTransforms || [],
                                cellFormatters: onCollapse ? [react_table_1.expandable] : [],
                            };
                        }), rows: rows, rowWrapper: OuiaIdRowWrapper, actionResolver: actionResolver, actions: actions, "aria-label": "Simple Table", sortBy: adjustedSort, onSort: function (_event, index, direction) { return updateSort({ index: index, direction: direction }); }, onSelect: 
                        /* istanbul ignore next */
                        rows.length && ((bulkActions === null || bulkActions === void 0 ? void 0 : bulkActions.length) || !!props.onSelect) ? onSelect : undefined, onCollapse: onCollapse, borders: !props.noBorders, variant: react_table_1.TableVariant.compact, gridBreakPoint: (_b = props.gridBreakPoint) !== null && _b !== void 0 ? _b : breakpoint },
                        react_1.default.createElement(react_table_1.TableHeader, null),
                        react_1.default.createElement(react_table_1.TableBody, null)))),
            !filtered.length && (react_1.default.createElement(react_core_1.PageSection, { variant: "light", padding: { default: 'noPadding' } },
                react_1.default.createElement(AcmEmptyState_1.AcmEmptyState, { title: "No results found", message: "No results match the filter criteria. Clear filters to show results.", showIcon: false, action: react_1.default.createElement(AcmButton_1.AcmButton, { variant: "link", onClick: function () { return updateSearch(''); } }, "Clear all filters") }))),
            (!props.autoHidePagination || filtered.length > perPage) && (react_1.default.createElement(react_core_1.Pagination, { itemCount: itemCount, perPage: perPage, page: page, variant: react_core_1.PaginationVariant.bottom, onSetPage: /* istanbul ignore next */ function (_event, page) { return setPage(page); }, onPerPageSelect: /* istanbul ignore next */ function (_event, perPage) { return updatePerPage(perPage); }, "aria-label": "Pagination bottom" }))))));
}
exports.AcmTable = AcmTable;
function compareItems(path) {
    return function (a, b) {
        return compareUnknowns(get_value_1.default(a, path), get_value_1.default(b, path));
    };
}
exports.compareItems = compareItems;
function compareUnknowns(a, b) {
    /* istanbul ignore next */
    if (a == undefined && b == undefined)
        return 0;
    /* istanbul ignore next */
    if (a == undefined)
        return 1;
    /* istanbul ignore next */
    if (b == undefined)
        return -1;
    /* istanbul ignore else */
    if (typeof a === 'string') {
        /* istanbul ignore else */
        if (typeof b === 'string') {
            return compareStrings(a, b);
        }
        else if (typeof b === 'number') {
            return compareStrings(a, b.toString());
        }
    }
    else if (typeof a === 'number') {
        /* istanbul ignore else */
        if (typeof b === 'number') {
            return compareNumbers(a, b);
        }
        else if (typeof b === 'string') {
            return compareStrings(a.toString(), b);
        }
    }
    /* istanbul ignore next */
    return 0;
}
exports.compareUnknowns = compareUnknowns;
/* istanbul ignore next */
function compareStrings(a, b) {
    if (a == undefined && b == undefined)
        return 0;
    if (a == undefined)
        return 1;
    if (b == undefined)
        return -1;
    return a < b ? -1 : a > b ? 1 : 0;
}
exports.compareStrings = compareStrings;
/* istanbul ignore next */
function compareNumbers(a, b) {
    if (a == undefined && b == undefined)
        return 0;
    if (a == undefined)
        return 1;
    if (b == undefined)
        return -1;
    return a < b ? -1 : a > b ? 1 : 0;
}
exports.compareNumbers = compareNumbers;
//# sourceMappingURL=AcmTable.js.map