"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Card = exports.CardContext = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const card_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Card/card"));
const react_styles_1 = require("@patternfly/react-styles");
const helpers_1 = require("../../helpers");
exports.CardContext = React.createContext({
    cardId: '',
    isExpanded: false
});
exports.Card = (_a) => {
    var { children = null, id = '', className = '', component = 'article', isHoverable = false, isCompact = false, isSelectable = false, isSelected = false, isFlat = false, isExpanded = false, isRounded = false, isLarge = false, isFullHeight = false, isPlain = false, ouiaId, ouiaSafe = true } = _a, props = tslib_1.__rest(_a, ["children", "id", "className", "component", "isHoverable", "isCompact", "isSelectable", "isSelected", "isFlat", "isExpanded", "isRounded", "isLarge", "isFullHeight", "isPlain", "ouiaId", "ouiaSafe"]);
    const Component = component;
    const ouiaProps = helpers_1.useOUIAProps(exports.Card.displayName, ouiaId, ouiaSafe);
    if (isCompact && isLarge) {
        // eslint-disable-next-line no-console
        console.warn('Card: Cannot use isCompact with isLarge. Defaulting to isCompact');
        isLarge = false;
    }
    return (React.createElement(exports.CardContext.Provider, { value: {
            cardId: id,
            isExpanded
        } },
        React.createElement(Component, Object.assign({ id: id, className: react_styles_1.css(card_1.default.card, isHoverable && card_1.default.modifiers.hoverable, isCompact && card_1.default.modifiers.compact, isSelectable && card_1.default.modifiers.selectable, isSelected && isSelectable && card_1.default.modifiers.selected, isExpanded && card_1.default.modifiers.expanded, isFlat && card_1.default.modifiers.flat, isRounded && card_1.default.modifiers.rounded, isLarge && card_1.default.modifiers.displayLg, isFullHeight && card_1.default.modifiers.fullHeight, isPlain && card_1.default.modifiers.plain, className), tabIndex: isSelectable ? '0' : undefined }, props, ouiaProps), children)));
};
exports.Card.displayName = 'Card';
//# sourceMappingURL=Card.js.map