"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _SearchBar = _interopRequireDefault(require("./SearchBar"));

var _i18n = _interopRequireDefault(require("../util/i18n"));

var _pluginState = require("../pluginState");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class SearchInput extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      searchSchema: [{
        id: 'loading',
        name: (0, _i18n.default)('search.loading'),
        disabled: true
      }]
    };
  }

  componentDidMount() {
    if ((0, _pluginState.getPluginState)().searchSchema.length > 0) {
      this.setState({
        searchSchema: (0, _pluginState.getPluginState)().searchSchema
      });
    } else {
      this.setState({
        searchSchema: (0, _pluginState.getPluginState)().default
      });
    }
  }

  render() {
    return /*#__PURE__*/_react.default.createElement(_SearchBar.default, {
      onKeyPress: this.props.onKeyPress,
      value: this.props.value,
      onChange: this.props.onChange,
      availableFilters: this.state.searchSchema
    });
  }

}

exports.default = SearchInput;
SearchInput.propTypes = {};