'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Tag extends _react.default.Component {
  getClassType(tag) {
    const {
      classNames
    } = this.props;

    switch (tag.classType) {
      case 'keyword':
        return 'react-tags__keyword-tag';

      default:
        return classNames.selectedTag;
    }
  }

  render() {
    const {
      classNames,
      onDelete,
      tag
    } = this.props;
    return /*#__PURE__*/_react.default.createElement("button", {
      type: "button",
      className: this.getClassType(tag),
      onClick: onDelete
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: classNames.selectedTagName
    }, tag.name));
  }

}

var _default = Tag;
exports.default = _default;