"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usage = usage;

var _i18n = _interopRequireDefault(require("../../util/i18n"));

var _searchSidecarHelp = require("./search-sidecar-help");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const contentType = 'text/html';
const apiVersion = 'kui-shell/v1';
const kind = 'NavResponse';
const sections = {
  introduction: {
    headers: [{
      header: (0, _i18n.default)('validation.about'),
      docs: (0, _i18n.default)('savedsearchhelp.title'),
      key: (0, _i18n.default)('validation.about')
    }, {
      header: (0, _i18n.default)('validation.usage'),
      docs: (0, _i18n.default)('savedsearchhelp.header'),
      key: (0, _i18n.default)('validation.usage'),
      usage: `savedsearches (alias: ss)`
    }, {
      header: (0, _i18n.default)('validation.guide'),
      docs: (0, _i18n.default)('validation.savedsearches.parameters'),
      key: (0, _i18n.default)('validation.guide')
    }]
  }
};

function usage() {
  return {
    apiVersion,
    kind,
    breadcrumbs: [{
      label: 'savedsearches'
    }],
    menus: [{
      label: (0, _i18n.default)('validation.usage'),
      items: [{
        mode: (0, _i18n.default)('validation.introduction'),
        content: (0, _searchSidecarHelp.getIntroduction)(sections.introduction.headers),
        contentType
      }]
    }],
    links: [{
      label: (0, _i18n.default)('validation.more.information'),
      href: 'https://github.com/open-cluster-management/rhacm-docs/blob/doc_stage/console/vwt_search.md#searching-with-visual-web-terminal'
    }]
  };
}