"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _default = (key, args) => {
  const defaultStrings = require(`../../i18n/en-US.json`);

  const locale = process.env.LOCALE || typeof navigator !== 'undefined' && navigator.language;

  const i18n = locale => {
    try {
      return locale && require(`../../i18n/${locale}.json`) || defaultStrings;
    } catch (err) {
      try {
        return locale && require(`../../i18n/${locale.replace(/-.*$/, '')}.json`) || defaultStrings;
      } catch (err) {
        console.error('Could not find translation for given locale', locale);
        return defaultStrings;
      }
    }
  };

  const _strings = Object.assign(Object.assign({}, defaultStrings), i18n(locale));

  let string = _strings[key];

  if (string && args) {
    args.forEach((arg, idx) => {
      string = string.replace(`{${idx}}`, arg);
    });
  }

  return string || defaultStrings[key] || key;
};

exports.default = _default;