"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertStringToQuery = void 0;

const convertStringToQuery = searchText => {
  let searchTokens = searchText.replace('search', '').trim(' ');

  if (searchTokens.includes('summary')) {
    searchTokens = searchTokens.replace('summary', '').split(' ');
  } else if (searchTokens.includes('--related')) {
    searchTokens = searchTokens.replace('--related', '').trim(' ').split(' ');
  } else {
    searchTokens = searchTokens.split(' ');
  }

  const keywords = searchTokens.filter(token => token !== '' && token.indexOf(':') < 0);
  const filters = searchTokens.filter(token => token.indexOf(':') >= 0).map(f => {
    let property;
    let values;

    if (f.includes('name:')) {
      [property, values] = ['name', f.replace('name:', '')];
    } else {
      [property, values] = f.split(':');
    }

    return {
      property,
      values: values.split(',')
    };
  }).filter(f => ['', '=', '<', '>', '<=', '>=', '!=', '!'].findIndex(op => op === f.values[0]) === -1);
  return {
    keywords,
    filters
  };
};

exports.convertStringToQuery = convertStringToQuery;