"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.editSpec = editSpec;
exports.yamlTab = void 0;

var _jsYaml = _interopRequireDefault(require("js-yaml"));

var _core = require("@kui-shell/core");

var _i18n = _interopRequireDefault(require("../../util/i18n"));

var _HTTPClient = _interopRequireDefault(require("../../controller/HTTPClient"));

var _searchQueries = require("../../definitions/search-queries");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function editSpec(cmd, resource, data) {
  return {
    readOnly: false,
    clearable: false,
    save: {
      label: (0, _i18n.default)('sidecar.yaml.edit.apply'),
      onSave: updated => __awaiter(this, void 0, void 0, function* () {
        (0, _HTTPClient.default)('post', 'console', (0, _searchQueries.UPDATE_RESOURCE)(_jsYaml.default.load(updated), data)).then(() => {
          (0, _core.doEval)((0, _core.getCurrentTab)(), undefined, cmd);
        }).catch(err => {
          console.debug(err);
        });
        return {
          noToolbarUpdate: true
        };
      })
    },
    revert: {
      label: (0, _i18n.default)('validation.revert'),
      onRevert: () => _jsYaml.default.dump(resource)
    }
  };
}

const yamlTab = (resource, data, cmd) => {
  const spec = editSpec(cmd, resource, data.items[0]);
  return {
    mode: 'yaml',
    label: 'YAML',
    order: 2,
    content: _jsYaml.default.dump(resource),
    contentType: 'yaml',
    spec
  };
};

exports.yamlTab = yamlTab;