if (!window || !window.navigator || !window.navigator.userAgent) {
    Object.defineProperty(window, 'navigator', { value: { userAgent: 'node' }, writable: true });
    Object.defineProperty(document, 'getElementById', {
        value: (val) => document.querySelector('#' + val),
        writable: true,
    });
}
import React from 'react';
import PropTypes from 'prop-types';
import { Dropdown } from 'carbon-components-react';
import lodash from 'lodash';
import HTTPClient from '../controller/HTTPClient';
import { RESOURCE_LOGS } from '../definitions/search-queries';
import strings from '../util/i18n';
export default class Logger extends React.PureComponent {
    constructor(props) {
        super(props);
        this.componentDidMount = () => {
            this.container = this.state.selectedItem;
            this.getLogs();
            this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
        };
        this.componentWillUnmount = () => {
            clearInterval(this.refresh);
        };
        this.isFocused = fn => {
            const focus = document.getElementsByClassName('kui--tab-navigatable kui--notab-when-sidecar-hidden bx--tabs__nav-link');
            return document.querySelector('.logs-container__content') && focus[0]['tabIndex'] >= 0
                ? fn()
                : document.querySelector('.visible.sidecar-is-minimized') &&
                    document.querySelector('.logs-container__content')
                    ? null
                    : this.componentWillUnmount();
        };
        this.state = {
            selectedItem: lodash.get(this.props.items, '[0]', ''),
            logs: '',
        };
        this.handleOnChange = this.handleOnChange.bind(this);
        this.getLogs = this.getLogs.bind(this);
        this.isFocused = this.isFocused.bind(this);
    }
    handleOnChange(event) {
        this.container = event.selectedItem;
        this.setState({ logs: '' });
        this.getLogs();
        clearInterval(this.refresh);
        this.refresh = setInterval(() => this.isFocused(this.getLogs), 15000);
    }
    getLogs() {
        if (!document.hidden) {
            const node = document.createElement('div');
            node.classList.add('scrollable');
            node.classList.add('bx--structured-list--summary');
            const record = {
                cluster: this.props.data.cluster,
                container: this.container,
                name: this.props.data.name,
                namespace: this.props.data.namespace,
            };
            HTTPClient('post', 'console', RESOURCE_LOGS(record)).then(res => {
                this.setState({
                    selectedItem: this.container,
                    logs: lodash.get(res, 'data.logs', '') !== null ? res.data.logs : strings('search.notfound'),
                });
            });
        }
    }
    render() {
        return (React.createElement(React.Fragment, null,
            React.createElement(Dropdown, { titleText: "", ariaLabel: "", id: "resource-container-dropdown", label: lodash.get(this.props.items, '[0]', ''), items: this.props.items, onChange: this.handleOnChange }),
            !this.state.logs ? (React.createElement("div", { className: "loading-container" }, 'Loading logs')) : (React.createElement("div", { className: "logs-container__content" },
                React.createElement("pre", null, this.state.logs)))));
    }
}
Logger.propTypes = {
    data: PropTypes.any,
    items: PropTypes.any,
};
//# sourceMappingURL=Logger.js.map