"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onQuit = onQuit;
exports.offQuit = offQuit;

var _ = require("..");

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/** Signals that indicate we are being terminated */
const signals = ['SIGINT', 'SIGTERM', 'SIGUSR1', 'SIGUSR2'];
/** Interface with process.on/off */

function toggle(op, handler) {
  return __awaiter(this, void 0, void 0, function* () {
    if (op === 'on') {
      process.on('exit', handler);
    } else {
      process.off('exit', handler);
    }

    signals.forEach(signal => {
      if (op === 'on') {
        process.on(signal, handler);
      } else {
        process.off(signal, handler);
      }
    });
  });
}

function onQuit(handler) {
  if ((0, _.isHeadless)()) {
    toggle('on', handler);
  } else if (typeof window.addEventListener === 'function') {
    window.addEventListener('beforeunload', handler);
  }
}

function offQuit(handler) {
  if ((0, _.isHeadless)()) {
    toggle('off', handler);
  } else if (typeof window.removeEventListener === 'function') {
    window.removeEventListener('beforeunload', handler);
  }
}