"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  History: true,
  hasProxy: true,
  getValidCredentials: true,
  inBrowser: true,
  inElectron: true,
  isHeadless: true,
  inSandbox: true,
  inProxy: true,
  assertInSandbox: true,
  assertLocalAccess: true,
  assertHasProxy: true,
  setHasAuth: true,
  getAuthValue: true,
  typeahead: true,
  ExecType: true,
  isCommandHandlerWithEvents: true,
  unparse: true,
  flatten: true,
  isScalarResponse: true,
  isMixedResponse: true,
  hasSourceReferences: true,
  isResourceByReference: true,
  hasDisplayName: true,
  isAbortableResponse: true,
  isMarkdownResponse: true,
  isReactResponse: true,
  isRandomErrorResponse1: true,
  isRandomErrorResponse2: true,
  isResourceWithMetadata: true,
  withLanguage: true,
  isCodedError: true,
  is404: true,
  is409: true,
  is404or409: true,
  isUsageError: true,
  UsageError: true,
  isMessageWithUsageModel: true,
  isMessageWithCode: true,
  renderUsage: true,
  pc: true,
  eventChannelUnsafe: true,
  wireToTabEvents: true,
  wireToStandardEvents: true,
  unwireToTabEvents: true,
  unwireToStandardEvents: true,
  eventBus: true,
  i18nFromMap: true,
  i18n: true,
  isWatchable: true,
  isResizable: true,
  isSuspendable: true,
  HistoryModel: true,
  prettyPrintTime: true,
  prettyPrintBytes: true,
  registerModeWhen: true,
  registerMode: true,
  addRelevantModes: true,
  registerBadge: true,
  badgeRegistrar: true,
  split: true,
  _split: true,
  splitIntoPipeStages: true,
  DirectReplEval: true,
  encodeComponent: true,
  internalBeCarefulExec: true,
  internalBeCarefulPExec: true,
  setEvaluatorImpl: true,
  doEval: true,
  isNotebook: true,
  getTab: true,
  getCurrentTab: true,
  pexecInCurrentTab: true,
  getTabId: true,
  getPrimaryTabId: true,
  sameTab: true,
  splitFor: true,
  isTopLevelTab: true,
  TabState: true,
  registerTabState: true,
  findThemeByName: true,
  getDefaultTheme: true,
  switchToTheme: true,
  getPersistedThemeChoice: true,
  resetToDefaultTheme: true,
  disableInputQueueing: true,
  isPopup: true,
  empty: true,
  Presentation: true,
  isCommentaryResponse: true,
  isTabLayoutModificationResponse: true,
  isNewSplitRequest: true,
  isButton: true,
  isViewButton: true,
  isNavResponse: true,
  isLink: true,
  isLinkWithHref: true,
  isLinkWithCommand: true,
  isXtermResponse: true,
  isXtermErrorResponse: true,
  isMultiModalResponse: true,
  hasContent: true,
  isScalarContent: true,
  isReactProvider: true,
  isCommandStringContent: true,
  isStringWithOptionalContentType: true,
  isSupportedContentType: true,
  isStringDiffContent: true,
  isFunctionContent: true,
  isSupportedToolbarTextType: true,
  doCancel: true,
  ElementMimic: true,
  KeyCodes: true,
  isCursorMovement: true,
  commandsOfferedByPlugin: true,
  pluginUserHome: true,
  userDataDir: true,
  uiThemes: true,
  Store: true,
  SymbolTable: true,
  Icon: true,
  TableStyle: true,
  Table: true,
  Row: true,
  Cell: true,
  sameRow: true,
  isTable: true,
  isTableWithTimestamp: true,
  isTableWithCount: true,
  isRadioTable: true,
  radioTableHintsAsCss: true,
  radioTableCellToString: true,
  radioTableAddHint: true,
  cellShouldHaveBadge: true,
  findFileWithViewer: true,
  findFile: true,
  isSpecialDirectory: true,
  expandHomeDir: true,
  cwd: true,
  promiseEach: true,
  isHTML: true,
  isPromise: true,
  tellMain: true,
  main: true,
  boot: true,
  bootIntoSandbox: true,
  initializeSession: true,
  registerTabCompletionEnumerator: true,
  isStringResponse: true,
  findCompletions: true,
  teeToFile: true,
  isOfflineClient: true
};
exports.History = History;
Object.defineProperty(exports, "hasProxy", {
  enumerable: true,
  get: function () {
    return _capabilities.hasProxy;
  }
});
Object.defineProperty(exports, "getValidCredentials", {
  enumerable: true,
  get: function () {
    return _capabilities.getValidCredentials;
  }
});
Object.defineProperty(exports, "inBrowser", {
  enumerable: true,
  get: function () {
    return _capabilities.inBrowser;
  }
});
Object.defineProperty(exports, "inElectron", {
  enumerable: true,
  get: function () {
    return _capabilities.inElectron;
  }
});
Object.defineProperty(exports, "isHeadless", {
  enumerable: true,
  get: function () {
    return _capabilities.isHeadless;
  }
});
Object.defineProperty(exports, "inSandbox", {
  enumerable: true,
  get: function () {
    return _capabilities.inSandbox;
  }
});
Object.defineProperty(exports, "inProxy", {
  enumerable: true,
  get: function () {
    return _capabilities.inProxy;
  }
});
Object.defineProperty(exports, "assertInSandbox", {
  enumerable: true,
  get: function () {
    return _capabilities.assertInSandbox;
  }
});
Object.defineProperty(exports, "assertLocalAccess", {
  enumerable: true,
  get: function () {
    return _capabilities.assertLocalAccess;
  }
});
Object.defineProperty(exports, "assertHasProxy", {
  enumerable: true,
  get: function () {
    return _capabilities.assertHasProxy;
  }
});
Object.defineProperty(exports, "setHasAuth", {
  enumerable: true,
  get: function () {
    return _capabilities.setHasAuth;
  }
});
Object.defineProperty(exports, "getAuthValue", {
  enumerable: true,
  get: function () {
    return _capabilities.getAuthValue;
  }
});
Object.defineProperty(exports, "typeahead", {
  enumerable: true,
  get: function () {
    return _typeahead.default;
  }
});
Object.defineProperty(exports, "ExecType", {
  enumerable: true,
  get: function () {
    return _command.ExecType;
  }
});
Object.defineProperty(exports, "isCommandHandlerWithEvents", {
  enumerable: true,
  get: function () {
    return _command.isCommandHandlerWithEvents;
  }
});
Object.defineProperty(exports, "unparse", {
  enumerable: true,
  get: function () {
    return _utility.optionsToString;
  }
});
Object.defineProperty(exports, "flatten", {
  enumerable: true,
  get: function () {
    return _utility.flatten;
  }
});
Object.defineProperty(exports, "isScalarResponse", {
  enumerable: true,
  get: function () {
    return _entity.isScalarResponse;
  }
});
Object.defineProperty(exports, "isMixedResponse", {
  enumerable: true,
  get: function () {
    return _entity.isMixedResponse;
  }
});
Object.defineProperty(exports, "hasSourceReferences", {
  enumerable: true,
  get: function () {
    return _entity.hasSourceReferences;
  }
});
Object.defineProperty(exports, "isResourceByReference", {
  enumerable: true,
  get: function () {
    return _entity.isMetadataBearingByReference;
  }
});
Object.defineProperty(exports, "hasDisplayName", {
  enumerable: true,
  get: function () {
    return _entity.hasDisplayName;
  }
});
Object.defineProperty(exports, "isAbortableResponse", {
  enumerable: true,
  get: function () {
    return _entity.isAbortableResponse;
  }
});
Object.defineProperty(exports, "isMarkdownResponse", {
  enumerable: true,
  get: function () {
    return _entity.isMarkdownResponse;
  }
});
Object.defineProperty(exports, "isReactResponse", {
  enumerable: true,
  get: function () {
    return _entity.isReactResponse;
  }
});
Object.defineProperty(exports, "isRandomErrorResponse1", {
  enumerable: true,
  get: function () {
    return _entity.isRandomErrorResponse1;
  }
});
Object.defineProperty(exports, "isRandomErrorResponse2", {
  enumerable: true,
  get: function () {
    return _entity.isRandomErrorResponse2;
  }
});
Object.defineProperty(exports, "isResourceWithMetadata", {
  enumerable: true,
  get: function () {
    return _entity.isMetadataBearing;
  }
});
Object.defineProperty(exports, "withLanguage", {
  enumerable: true,
  get: function () {
    return _execOptions.withLanguage;
  }
});
Object.defineProperty(exports, "isCodedError", {
  enumerable: true,
  get: function () {
    return _errors.isCodedError;
  }
});
Object.defineProperty(exports, "is404", {
  enumerable: true,
  get: function () {
    return _errors.is404;
  }
});
Object.defineProperty(exports, "is409", {
  enumerable: true,
  get: function () {
    return _errors.is409;
  }
});
Object.defineProperty(exports, "is404or409", {
  enumerable: true,
  get: function () {
    return _errors.is404or409;
  }
});
Object.defineProperty(exports, "isUsageError", {
  enumerable: true,
  get: function () {
    return _usageError.isUsageError;
  }
});
Object.defineProperty(exports, "UsageError", {
  enumerable: true,
  get: function () {
    return _usageError.UsageError;
  }
});
Object.defineProperty(exports, "isMessageWithUsageModel", {
  enumerable: true,
  get: function () {
    return _usageError.isMessageWithUsageModel;
  }
});
Object.defineProperty(exports, "isMessageWithCode", {
  enumerable: true,
  get: function () {
    return _usageError.isMessageWithCode;
  }
});
Object.defineProperty(exports, "renderUsage", {
  enumerable: true,
  get: function () {
    return _renderUsage.default;
  }
});
Object.defineProperty(exports, "eventChannelUnsafe", {
  enumerable: true,
  get: function () {
    return _events.default;
  }
});
Object.defineProperty(exports, "wireToTabEvents", {
  enumerable: true,
  get: function () {
    return _events.wireToTabEvents;
  }
});
Object.defineProperty(exports, "wireToStandardEvents", {
  enumerable: true,
  get: function () {
    return _events.wireToStandardEvents;
  }
});
Object.defineProperty(exports, "unwireToTabEvents", {
  enumerable: true,
  get: function () {
    return _events.unwireToTabEvents;
  }
});
Object.defineProperty(exports, "unwireToStandardEvents", {
  enumerable: true,
  get: function () {
    return _events.unwireToStandardEvents;
  }
});
Object.defineProperty(exports, "eventBus", {
  enumerable: true,
  get: function () {
    return _events.eventBus;
  }
});
Object.defineProperty(exports, "i18nFromMap", {
  enumerable: true,
  get: function () {
    return _i18n.fromMap;
  }
});
Object.defineProperty(exports, "i18n", {
  enumerable: true,
  get: function () {
    return _i18n.default;
  }
});
Object.defineProperty(exports, "isWatchable", {
  enumerable: true,
  get: function () {
    return _watchable.isWatchable;
  }
});
Object.defineProperty(exports, "isResizable", {
  enumerable: true,
  get: function () {
    return _job.isResizable;
  }
});
Object.defineProperty(exports, "isSuspendable", {
  enumerable: true,
  get: function () {
    return _job.isSuspendable;
  }
});
Object.defineProperty(exports, "HistoryModel", {
  enumerable: true,
  get: function () {
    return _history.HistoryModel;
  }
});
Object.defineProperty(exports, "prettyPrintTime", {
  enumerable: true,
  get: function () {
    return _time.prettyPrintTime;
  }
});
Object.defineProperty(exports, "prettyPrintBytes", {
  enumerable: true,
  get: function () {
    return _bytes.default;
  }
});
Object.defineProperty(exports, "registerModeWhen", {
  enumerable: true,
  get: function () {
    return _modes.registerModeWhen;
  }
});
Object.defineProperty(exports, "registerMode", {
  enumerable: true,
  get: function () {
    return _modes.registerSidecarMode;
  }
});
Object.defineProperty(exports, "addRelevantModes", {
  enumerable: true,
  get: function () {
    return _modes.apply;
  }
});
Object.defineProperty(exports, "registerBadge", {
  enumerable: true,
  get: function () {
    return _badges.registerSidecarBadge;
  }
});
Object.defineProperty(exports, "badgeRegistrar", {
  enumerable: true,
  get: function () {
    return _badges.registrar;
  }
});
Object.defineProperty(exports, "split", {
  enumerable: true,
  get: function () {
    return _split.split;
  }
});
Object.defineProperty(exports, "_split", {
  enumerable: true,
  get: function () {
    return _split._split;
  }
});
Object.defineProperty(exports, "splitIntoPipeStages", {
  enumerable: true,
  get: function () {
    return _pipeStages.splitIntoPipeStages;
  }
});
Object.defineProperty(exports, "DirectReplEval", {
  enumerable: true,
  get: function () {
    return _types.DirectReplEval;
  }
});
Object.defineProperty(exports, "encodeComponent", {
  enumerable: true,
  get: function () {
    return _encode.default;
  }
});
Object.defineProperty(exports, "internalBeCarefulExec", {
  enumerable: true,
  get: function () {
    return _exec.exec;
  }
});
Object.defineProperty(exports, "internalBeCarefulPExec", {
  enumerable: true,
  get: function () {
    return _exec.pexec;
  }
});
Object.defineProperty(exports, "setEvaluatorImpl", {
  enumerable: true,
  get: function () {
    return _exec.setEvaluatorImpl;
  }
});
Object.defineProperty(exports, "doEval", {
  enumerable: true,
  get: function () {
    return _exec.doEval;
  }
});
Object.defineProperty(exports, "isNotebook", {
  enumerable: true,
  get: function () {
    return _events2.isNotebook;
  }
});
Object.defineProperty(exports, "getTab", {
  enumerable: true,
  get: function () {
    return _tab.getTab;
  }
});
Object.defineProperty(exports, "getCurrentTab", {
  enumerable: true,
  get: function () {
    return _tab.getCurrentTab;
  }
});
Object.defineProperty(exports, "pexecInCurrentTab", {
  enumerable: true,
  get: function () {
    return _tab.pexecInCurrentTab;
  }
});
Object.defineProperty(exports, "getTabId", {
  enumerable: true,
  get: function () {
    return _tab.getTabId;
  }
});
Object.defineProperty(exports, "getPrimaryTabId", {
  enumerable: true,
  get: function () {
    return _tab.getPrimaryTabId;
  }
});
Object.defineProperty(exports, "sameTab", {
  enumerable: true,
  get: function () {
    return _tab.sameTab;
  }
});
Object.defineProperty(exports, "splitFor", {
  enumerable: true,
  get: function () {
    return _tab.splitFor;
  }
});
Object.defineProperty(exports, "isTopLevelTab", {
  enumerable: true,
  get: function () {
    return _tab.isTopLevelTab;
  }
});
Object.defineProperty(exports, "TabState", {
  enumerable: true,
  get: function () {
    return _tabState.default;
  }
});
Object.defineProperty(exports, "registerTabState", {
  enumerable: true,
  get: function () {
    return _tabState.registerTabState;
  }
});
Object.defineProperty(exports, "findThemeByName", {
  enumerable: true,
  get: function () {
    return _find.findByName;
  }
});
Object.defineProperty(exports, "getDefaultTheme", {
  enumerable: true,
  get: function () {
    return _default.getDefault;
  }
});
Object.defineProperty(exports, "switchToTheme", {
  enumerable: true,
  get: function () {
    return _persistence.switchTo;
  }
});
Object.defineProperty(exports, "getPersistedThemeChoice", {
  enumerable: true,
  get: function () {
    return _persistence.getPersistedThemeChoice;
  }
});
Object.defineProperty(exports, "resetToDefaultTheme", {
  enumerable: true,
  get: function () {
    return _persistence.resetToDefault;
  }
});
Object.defineProperty(exports, "disableInputQueueing", {
  enumerable: true,
  get: function () {
    return _queueing.disableInputQueueing;
  }
});
Object.defineProperty(exports, "isPopup", {
  enumerable: true,
  get: function () {
    return _popupCore.isPopup;
  }
});
Object.defineProperty(exports, "empty", {
  enumerable: true,
  get: function () {
    return _dom.removeAllDomChildren;
  }
});
Object.defineProperty(exports, "Presentation", {
  enumerable: true,
  get: function () {
    return _presentation.default;
  }
});
Object.defineProperty(exports, "isCommentaryResponse", {
  enumerable: true,
  get: function () {
    return _CommentaryResponse.isCommentaryResponse;
  }
});
Object.defineProperty(exports, "isTabLayoutModificationResponse", {
  enumerable: true,
  get: function () {
    return _TabLayoutModificationResponse.isTabLayoutModificationResponse;
  }
});
Object.defineProperty(exports, "isNewSplitRequest", {
  enumerable: true,
  get: function () {
    return _TabLayoutModificationResponse.isNewSplitRequest;
  }
});
Object.defineProperty(exports, "isButton", {
  enumerable: true,
  get: function () {
    return _types2.isButton;
  }
});
Object.defineProperty(exports, "isViewButton", {
  enumerable: true,
  get: function () {
    return _types2.isViewButton;
  }
});
Object.defineProperty(exports, "isNavResponse", {
  enumerable: true,
  get: function () {
    return _NavResponse.isNavResponse;
  }
});
Object.defineProperty(exports, "isLink", {
  enumerable: true,
  get: function () {
    return _NavResponse.isLink;
  }
});
Object.defineProperty(exports, "isLinkWithHref", {
  enumerable: true,
  get: function () {
    return _NavResponse.isLinkWithHref;
  }
});
Object.defineProperty(exports, "isLinkWithCommand", {
  enumerable: true,
  get: function () {
    return _NavResponse.isLinkWithCommand;
  }
});
Object.defineProperty(exports, "isXtermResponse", {
  enumerable: true,
  get: function () {
    return _XtermResponse.isXtermResponse;
  }
});
Object.defineProperty(exports, "isXtermErrorResponse", {
  enumerable: true,
  get: function () {
    return _XtermResponse.isXtermErrorResponse;
  }
});
Object.defineProperty(exports, "isMultiModalResponse", {
  enumerable: true,
  get: function () {
    return _is.isMultiModalResponse;
  }
});
Object.defineProperty(exports, "hasContent", {
  enumerable: true,
  get: function () {
    return _contentTypes.hasContent;
  }
});
Object.defineProperty(exports, "isScalarContent", {
  enumerable: true,
  get: function () {
    return _contentTypes.isScalarContent;
  }
});
Object.defineProperty(exports, "isReactProvider", {
  enumerable: true,
  get: function () {
    return _contentTypes.isReactProvider;
  }
});
Object.defineProperty(exports, "isCommandStringContent", {
  enumerable: true,
  get: function () {
    return _contentTypes.isCommandStringContent;
  }
});
Object.defineProperty(exports, "isStringWithOptionalContentType", {
  enumerable: true,
  get: function () {
    return _contentTypes.isStringWithOptionalContentType;
  }
});
Object.defineProperty(exports, "isSupportedContentType", {
  enumerable: true,
  get: function () {
    return _contentTypes.isSupportedContentType;
  }
});
Object.defineProperty(exports, "isStringDiffContent", {
  enumerable: true,
  get: function () {
    return _contentTypes.isStringDiffContent;
  }
});
Object.defineProperty(exports, "isFunctionContent", {
  enumerable: true,
  get: function () {
    return _contentTypes.isFunctionContent;
  }
});
Object.defineProperty(exports, "isSupportedToolbarTextType", {
  enumerable: true,
  get: function () {
    return _toolbarText.isSupportedToolbarTextType;
  }
});
Object.defineProperty(exports, "doCancel", {
  enumerable: true,
  get: function () {
    return _cancel.default;
  }
});
Object.defineProperty(exports, "ElementMimic", {
  enumerable: true,
  get: function () {
    return _elementMimic.default;
  }
});
Object.defineProperty(exports, "KeyCodes", {
  enumerable: true,
  get: function () {
    return _keys.keys;
  }
});
Object.defineProperty(exports, "isCursorMovement", {
  enumerable: true,
  get: function () {
    return _keys.isCursorMovement;
  }
});
Object.defineProperty(exports, "commandsOfferedByPlugin", {
  enumerable: true,
  get: function () {
    return _plugins.commandsOffered;
  }
});
Object.defineProperty(exports, "pluginUserHome", {
  enumerable: true,
  get: function () {
    return _plugins.userHome;
  }
});
Object.defineProperty(exports, "userDataDir", {
  enumerable: true,
  get: function () {
    return _settings.userDataDir;
  }
});
Object.defineProperty(exports, "uiThemes", {
  enumerable: true,
  get: function () {
    return _settings.uiThemes;
  }
});
Object.defineProperty(exports, "Store", {
  enumerable: true,
  get: function () {
    return _store.default;
  }
});
Object.defineProperty(exports, "SymbolTable", {
  enumerable: true,
  get: function () {
    return _symbolTable.default;
  }
});
Object.defineProperty(exports, "Icon", {
  enumerable: true,
  get: function () {
    return _table.Icon;
  }
});
Object.defineProperty(exports, "TableStyle", {
  enumerable: true,
  get: function () {
    return _table.TableStyle;
  }
});
Object.defineProperty(exports, "Table", {
  enumerable: true,
  get: function () {
    return _table.Table;
  }
});
Object.defineProperty(exports, "Row", {
  enumerable: true,
  get: function () {
    return _table.Row;
  }
});
Object.defineProperty(exports, "Cell", {
  enumerable: true,
  get: function () {
    return _table.Cell;
  }
});
Object.defineProperty(exports, "sameRow", {
  enumerable: true,
  get: function () {
    return _table.sameRow;
  }
});
Object.defineProperty(exports, "isTable", {
  enumerable: true,
  get: function () {
    return _table.isTable;
  }
});
Object.defineProperty(exports, "isTableWithTimestamp", {
  enumerable: true,
  get: function () {
    return _table.isTableWithTimestamp;
  }
});
Object.defineProperty(exports, "isTableWithCount", {
  enumerable: true,
  get: function () {
    return _table.isTableWithCount;
  }
});
Object.defineProperty(exports, "isRadioTable", {
  enumerable: true,
  get: function () {
    return _RadioTable.isRadioTable;
  }
});
Object.defineProperty(exports, "radioTableHintsAsCss", {
  enumerable: true,
  get: function () {
    return _RadioTable.radioTableHintsAsCss;
  }
});
Object.defineProperty(exports, "radioTableCellToString", {
  enumerable: true,
  get: function () {
    return _RadioTable.radioTableCellToString;
  }
});
Object.defineProperty(exports, "radioTableAddHint", {
  enumerable: true,
  get: function () {
    return _RadioTable.radioTableAddHint;
  }
});
Object.defineProperty(exports, "cellShouldHaveBadge", {
  enumerable: true,
  get: function () {
    return _RadioTable.cellShouldHaveBadge;
  }
});
Object.defineProperty(exports, "findFileWithViewer", {
  enumerable: true,
  get: function () {
    return _findFile.findFileWithViewer;
  }
});
Object.defineProperty(exports, "findFile", {
  enumerable: true,
  get: function () {
    return _findFile.findFile;
  }
});
Object.defineProperty(exports, "isSpecialDirectory", {
  enumerable: true,
  get: function () {
    return _findFile.isSpecialDirectory;
  }
});
Object.defineProperty(exports, "expandHomeDir", {
  enumerable: true,
  get: function () {
    return _home.expandHomeDir;
  }
});
Object.defineProperty(exports, "cwd", {
  enumerable: true,
  get: function () {
    return _home.cwd;
  }
});
Object.defineProperty(exports, "promiseEach", {
  enumerable: true,
  get: function () {
    return _async.promiseEach;
  }
});
Object.defineProperty(exports, "isHTML", {
  enumerable: true,
  get: function () {
    return _types3.isHTML;
  }
});
Object.defineProperty(exports, "isPromise", {
  enumerable: true,
  get: function () {
    return _types3.isPromise;
  }
});
Object.defineProperty(exports, "tellMain", {
  enumerable: true,
  get: function () {
    return _electronEvents.tellMain;
  }
});
Object.defineProperty(exports, "main", {
  enumerable: true,
  get: function () {
    return _main.main;
  }
});
Object.defineProperty(exports, "boot", {
  enumerable: true,
  get: function () {
    return _boot.default;
  }
});
Object.defineProperty(exports, "bootIntoSandbox", {
  enumerable: true,
  get: function () {
    return _boot.bootIntoSandbox;
  }
});
Object.defineProperty(exports, "initializeSession", {
  enumerable: true,
  get: function () {
    return _init.initializeSession;
  }
});
Object.defineProperty(exports, "registerTabCompletionEnumerator", {
  enumerable: true,
  get: function () {
    return _tabCompletion.registerEnumerator;
  }
});
Object.defineProperty(exports, "isStringResponse", {
  enumerable: true,
  get: function () {
    return _tabCompletion.isStringResponse;
  }
});
Object.defineProperty(exports, "findCompletions", {
  enumerable: true,
  get: function () {
    return _tabCompletion.applyEnumerator;
  }
});
Object.defineProperty(exports, "teeToFile", {
  enumerable: true,
  get: function () {
    return _tee.default;
  }
});
Object.defineProperty(exports, "isOfflineClient", {
  enumerable: true,
  get: function () {
    return _client.isOfflineClient;
  }
});
exports.pc = void 0;

var _capabilities = require("./core/capabilities");

var _typeahead = _interopRequireDefault(require("./commands/typeahead"));

var _command = require("./models/command");

var _utility = require("./core/utility");

var _entity = require("./models/entity");

var _execOptions = require("./models/execOptions");

var _errors = require("./models/errors");

var _usageError = require("./core/usage-error");

var _renderUsage = _interopRequireDefault(require("./core/usage/render-usage"));

var pc = _interopRequireWildcard(require("./core/usage/pretty-code"));

exports.pc = pc;

var _events = _interopRequireWildcard(require("./core/events"));

var _i18n = _interopRequireWildcard(require("./util/i18n"));

var _watchable = require("./core/jobs/watchable");

var _job = require("./core/jobs/job");

var _history = require("./models/history");

var _time = require("./webapp/util/time");

var _bytes = _interopRequireDefault(require("./webapp/util/bytes"));

var _modes = require("./webapp/views/registrar/modes");

var _badges = require("./webapp/views/registrar/badges");

var _split = require("./repl/split");

var _pipeStages = require("./repl/pipe-stages");

var _types = require("./repl/types");

var _encode = _interopRequireDefault(require("./repl/encode"));

var _exec = require("./repl/exec");

var _events2 = require("./repl/events");

var _tab = require("./webapp/tab");

var _tabState = _interopRequireWildcard(require("./models/tab-state"));

var _find = require("./webapp/themes/find");

var _default = require("./webapp/themes/default");

var _persistence = require("./webapp/themes/persistence");

var _queueing = require("./webapp/queueing");

var _popupCore = require("./webapp/popup-core");

var _dom = require("./webapp/util/dom");

var _presentation = _interopRequireDefault(require("./webapp/views/presentation"));

var _CommentaryResponse = require("./models/CommentaryResponse");

var _TabLayoutModificationResponse = require("./models/TabLayoutModificationResponse");

var _types2 = require("./models/mmr/types");

var _NavResponse = require("./models/NavResponse");

var _XtermResponse = require("./models/XtermResponse");

var _is = require("./models/mmr/is");

var _contentTypes = require("./models/mmr/content-types");

var _toolbarText = require("./webapp/views/toolbar-text");

var _cancel = _interopRequireDefault(require("./webapp/cancel"));

var _elementMimic = _interopRequireDefault(require("./util/element-mimic"));

var _keys = require("./webapp/keys");

var _plugins = require("./api/plugins");

var _settings = require("./core/settings");

var _store = _interopRequireDefault(require("./models/store"));

var _symbolTable = _interopRequireDefault(require("./core/symbol-table"));

var _table = require("./webapp/models/table");

var _RadioTable = require("./models/RadioTable");

var _findFile = require("./core/find-file");

var _home = require("./util/home");

var _async = require("./util/async");

var _types3 = require("./util/types");

var _electronEvents = require("./webapp/electron-events");

var _main = require("./main/main");

var _boot = _interopRequireWildcard(require("./webapp/bootstrap/boot"));

var _init = require("./session/init");

var _tabCompletion = require("./repl/tab-completion");

var _tee = _interopRequireDefault(require("./util/tee"));

var _client = require("./api/client");

var _windowEvents = require("./api/window-events");

Object.keys(_windowEvents).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _windowEvents[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _windowEvents[key];
    }
  });
});

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Capabilities
// Commands
// Errors
// TODO remove these soon; see plugin-client-common/src/components/Scalar/index.ts
// ascii usage
// eventChannelUnsafe
// i18n
// models
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function History(tab) {
  return (0, _history.getHistoryForTab)(typeof tab === 'string' ? tab : tab.uuid);
}