"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splitIntoPipeStages = splitIntoPipeStages;

var _split = require("./split");

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Split a given `command` line into the stages of the pipeline
 *
 * e.g. if command=`a -- b c|d > e`, then
 * pipeStages=`{ prefix: 'a', stages: [['b','c'],'d'], redirect: 'e' }`
 *
 */
function splitIntoPipeStages(command) {
  const dashDashPattern = /--\s/;
  const redirectPattern = /([^"'\\])>/;
  const dashDashMatch = command.match(dashDashPattern);
  const pipeStartIdx = dashDashMatch ? dashDashMatch.index + '--'.length : undefined;
  const prefix = !dashDashMatch ? '' : command.slice(0, dashDashMatch.index).trim();
  const redirectMatch = command.match(redirectPattern);
  const pipeEndIdx = redirectMatch ? redirectMatch.index : undefined;
  const redirect = !redirectMatch ? '' : command.slice(pipeEndIdx).replace(/^\s*>/, '').trim();
  const stages = (0, _split.split)(command, false, undefined, '|', pipeStartIdx, pipeEndIdx).map(_ => (0, _split.split)(_, false).map(_ => _.replace(/\\\s/g, '')));
  return {
    prefix,
    stages,
    redirect
  };
}