/// <reference types="node" />
import { EventEmitter } from 'events';
import { ScalarResponse } from '../models/entity';
import MultiModalResponse from '../models/mmr/types';
import NavResponse from '../models/NavResponse';
import TabState from '../models/tab-state';
import Tab from '../webapp/tab';
import { CommandStartEvent, CommandCompleteEvent, CommandStartHandler, CommandCompleteHandler } from '../repl/events';
declare const eventChannelUnsafe: EventEmitter;
export default eventChannelUnsafe;
export declare type StatusStripeChangeEvent = {
    type: 'default' | 'blue' | 'yellow' | 'red';
    message?: string;
};
export declare type SnapshotRequestEvent = {
    cb: (snapshot: Buffer) => void;
    filter?: (evt: CommandStartEvent) => boolean;
    opts?: {
        name?: string;
        description?: string;
        preferReExecute?: boolean;
        shallow?: boolean;
    };
};
export declare type TabLayoutChangeEvent = {
    isSidecarNowHidden: boolean;
    isWidthConstrained?: boolean;
};
declare type TabLayoutChangeHandler = (evt: TabLayoutChangeEvent) => void;
declare class EventBusBase {
    protected readonly eventBus: EventEmitter;
    constructor();
}
export interface NewTabRequestEvent {
    /** Optionally specify color and message to display in the StatusStripe */
    statusStripeDecoration?: StatusStripeChangeEvent;
    /** Optional tab title */
    title?: string;
    /** Optionally specify to create the new tab without switching to it */
    background?: boolean;
    /** Optionally execute a command in the new tab */
    cmdline?: string;
    /** Optionally open a snapshot file in the new tab */
    snapshot?: Buffer;
    /** Execute the command line with qexec or pexec? Default: pexec. */
    exec?: 'pexec' | 'qexec';
    /** Optionally execute a command when the tab is closed */
    onClose?: string;
}
declare class WriteEventBus extends EventBusBase {
    emit(channel: '/tab/new' | '/tab/close' | '/tab/offline', tab: Tab): void;
    emit(channel: '/tab/new/request', evt?: NewTabRequestEvent): void;
    emit(channel: '/tab/switch/request', idx: number): void;
    emit(channel: '/tab/switch/request/done', args: {
        idx: number;
        tab: TabState;
    }): void;
    /** User switching focus from one Split to another, within one Tab */
    emitSplitSwitch(tab: Tab): void;
    emitTabLayoutChange(tabUUID: string, evt?: TabLayoutChangeEvent): void;
    emitEnvUpdate(key: string, value: string): void;
    private emitCommandEvent;
    emitCommandStart(event: CommandStartEvent, isReplay?: boolean): void;
    emitCommandComplete(event: CommandCompleteEvent, isReplay?: boolean): void;
    /** Request a Snapshot of the given Tab */
    emitSnapshotRequest(evt: SnapshotRequestEvent, tabId: string): void;
    /** Request a status stripe change */
    emitStatusStripeChangeRequest(evt: StatusStripeChangeEvent): void;
    emitWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, tab?: Tab): void;
}
declare class ReadEventBus extends WriteEventBus {
    on(channel: '/tab/new' | '/tab/close/request' | '/tab/close' | '/tab/offline', listener: (tab: Tab) => void): void;
    on(channel: '/tab/new/request', listener: (evt: NewTabRequestEvent) => void): void;
    on(channel: '/tab/switch/request', listener: (tabId: number) => void): void;
    on(channel: '/tab/switch/request/done', listener: (tabId: number, tabState: TabState) => void): void;
    off(channel: string, listener: any): EventEmitter;
    onRemoveSnapshotable(listener: () => void): void;
    /** Snapshot the Block state of the given Tab */
    onSnapshotRequest(listener: (evt: SnapshotRequestEvent) => void, tabId: string): void;
    /** Snapshot the Block state of the given Tab */
    offSnapshotRequest(listener: (evt: SnapshotRequestEvent) => void, tabId: string): void;
    /** Request a status stripe change */
    onStatusStripeChangeRequest(listener: (evt: StatusStripeChangeEvent) => void): void;
    /** Request a status stripe change */
    offStatusStripeChangeRequest(listener: (evt: StatusStripeChangeEvent) => void): void;
    /** User switching focus from one Split to another, within one Tab */
    onSplitSwitch(listener: (tab?: Tab | number) => void): void;
    /** User switching focus from one Split to another, within one Tab */
    offSplitSwitch(listener: (tab?: Tab | number) => void): void;
    onTabLayoutChange(tabUUID: string, listener: TabLayoutChangeHandler): void;
    offTabLayoutChange(tabUUID: string, listener: TabLayoutChangeHandler): void;
    onEnvUpdate(key: string, listener: (value: string) => void): void;
    offEnvUpdate(key: string, listener: (value: string) => void): void;
    private onCommand;
    private offCommand;
    onAnyCommandStart(handler: CommandStartHandler): void;
    offAnyCommandStart(handler: CommandStartHandler): void;
    onAnyCommandComplete(handler: CommandCompleteHandler | (() => void)): void;
    offAnyCommandComplete(handler: CommandCompleteHandler | (() => void)): void;
    onCommandStart(splitId: string, splitHandler: CommandStartHandler, onReplay?: boolean): void;
    onceCommandStarts(tabId: string, handler: CommandStartHandler): void;
    private onResponseType;
    private offResponseType;
    onScalarResponse(splitId: string, splitHandler: CommandCompleteHandler<ScalarResponse>): void;
    offScalarResponse(splitId: string, splitHandler: CommandCompleteHandler<ScalarResponse>): void;
    onMultiModalResponse(tabId: string, handler: CommandCompleteHandler<MultiModalResponse, 'MultiModalResponse'>, onReplay?: boolean): void;
    offMultiModalResponse(tabId: string, handler: CommandCompleteHandler<MultiModalResponse, 'MultiModalResponse'>): void;
    onNavResponse(tabId: string, handler: CommandCompleteHandler<NavResponse, 'NavResponse'>, onReplay?: boolean): void;
    offNavResponse(tabId: string, handler: CommandCompleteHandler<NavResponse, 'NavResponse'>): void;
    onCommandComplete(splitId: string, splitHandler: CommandCompleteHandler, onReplay?: boolean): void;
    offCommandStart(splitId: string, splitHandler: CommandStartHandler): void;
    offCommandComplete(splitId: string, splitHandler: CommandCompleteHandler): void;
    onWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    offWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    onceWithTabId(channel: '/tab/offline' | '/tab/close/request', tabId: string, listener: (tabId: string, tab: Tab) => void): void;
    once(channel: '/tab/new', listener: (tab: Tab) => void): void;
}
declare class EventBus extends ReadEventBus {
}
export declare const eventBus: EventBus;
/**
 * Hook an event listener up to tab events.
 *
 */
export declare function wireToTabEvents(listener: (tab?: Tab | number) => void): void;
/**
 * Unhook
 *
 */
export declare function unwireToTabEvents(listener: (tab?: Tab | number) => void): void;
/**
 * Hook an event listener up to the family of standard user
 * interaction events.
 *
 */
export declare function wireToStandardEvents(listener: (tab?: Tab | number) => void): void;
/**
 * Unhook
 *
 */
export declare function unwireToStandardEvents(listener: (tab?: Tab | number) => void): void;
