/**
 * Get the userdata directory
 *
 */
export declare const userDataDir: () => string;
/**
 * Purge the preference model
 *
 */
export declare const purgePreferences: () => Promise<void>;
/**
 * Remove the preference associated with the given key
 *
 * @return the prior value
 *
 */
export declare const clearPreference: (key: string) => Promise<string>;
/**
 * Get a persisted preference
 *
 * @return the preference value
 *
 */
export declare const getPreference: (key: string) => Promise<string>;
/**
 * Set a persisted preference
 *
 * @return the preference value
 *
 */
export declare const setPreference: (key: string, value: string) => Promise<string>;
