import { UsageRow } from '../core/usage-error';
export interface CodedError<Code = number> extends Error {
    hide?: boolean;
    code?: Code;
    statusCode?: number;
    partialMatches?: UsageRow[];
    body?: string | Record<string, any>;
}
export declare function isCodedError<Code = number>(err: string | object | Error): err is CodedError<Code>;
export declare function is404<Code = number>(err: string | object | Error): err is CodedError<404>;
export declare function is409<Code = number>(err: string | object | Error): err is CodedError<409>;
export declare function is404or409<Code = number>(err: string | object | Error): err is CodedError<404 | 409>;
