import { StatusStripeChangeEvent } from '../core/events';
declare type CaptureFn = (tabState: TabState) => void | Promise<void>;
declare type RestoreFn = (tabState: TabState) => void | Promise<void>;
declare type SwitchToFn = (currentTabState: TabState, nextTabState: TabState) => void | Promise<void>;
interface TabStateRegistration {
    name: string;
    apiVersion: string;
    capture: CaptureFn;
    restore: RestoreFn;
    switchTo: SwitchToFn;
}
export declare function registerTabState(registration: TabStateRegistration): void;
/**
 * State that we want to keep per tab
 *
 */
export default class TabState {
    readonly uuid: string;
    private _desiredStatusStripeDecoration;
    private _parent?;
    /** is the tab ready for command execution? */
    ready: boolean;
    /** is the tab closed? */
    closed: boolean;
    /** state map
     * outer key is `TabStateRegistrar.name`, inner key is `TabStateRegistrar.apiVersion`
     * e.g. { 'plugins/plugin-core': {'v1': {'cwd': '/'}}}
     */
    private _state;
    /** functions to capture the states of tab */
    private captures;
    /** functions to restore the states of the tab */
    private restores;
    /** functions to capture this tab state and restore another tab state */
    private switchTos;
    constructor(uuid: string, _desiredStatusStripeDecoration?: StatusStripeChangeEvent, _parent?: TabState);
    get state(): Record<string, Record<string, any>>;
    private checkExistence;
    register(name: string, apiVersion: string, capture: CaptureFn, restore: RestoreFn, switchTo: SwitchToFn): void;
    getState(name: string, apiVersion: string, key: string): any;
    setState(name: string, apiVersion: string, key: string, value: any): Promise<void>;
    /** Capture contextual global state */
    capture(): void;
    /** Capture contextual global state and then restore `nextTabState` */
    switchTo(nextTabState: TabState): Promise<void>;
    /** Clone the captured state */
    cloneWithUUID(uuid: string): TabState;
    /** Enforce our desired status stripe decorations */
    updateStatusStripe(): void;
    get desiredStatusStripeDecoration(): StatusStripeChangeEvent;
    set desiredStatusStripeDecoration(decor: StatusStripeChangeEvent);
    /**
     * Restore tab state
     *
     */
    restore(): Promise<void>;
}
export {};
