import { PrescanModel } from './prescan';
import { CommandBase } from '../models/command';
import { KuiPlugin } from '../models/plugin';
export interface PluginResolver {
    /**
     * Look for a plugin that might be able to handle the given
     * `route`. If `tryCatchalls` is true, then the caller is desperate,
     * and wants us to see if there are any plugins that might have a
     * catchall that could possibly service the given `route`.
     *
     */
    resolve: (route: string, options?: {
        subtree?: boolean;
        tryCatchalls: boolean;
    }) => void;
    disambiguate: (route: string) => CommandBase[];
    disambiguatePartial: (partial: string) => string[];
    /**
     * Unconditionally resolve the given named `plugin`
     *
     */
    resolveOne: (plugin: string) => Promise<KuiPlugin>;
    /**
     * Has the given `route` been overridden by some plugin?
     *
     */
    isOverridden: (route: string) => boolean;
    /**
     * Is the given `plugin` the definitive master of the given `route`?
     * it might not be, if some other plugin has overridden it
     */
    isAlpha: (route: string, plugin: string) => boolean;
}
/**
 * Make a plugin resolver from a given prescan model
 *
 */
export declare const makeResolver: (prescan: PrescanModel, registrar: Record<string, KuiPlugin>) => PluginResolver;
