/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import Debug from 'debug';
import { uiThemes } from '../../core/settings';
const debug = Debug('core/webapp/themes/default');
/**
 * @return the name of the default theme
 *
 */
export function getDefault() {
    return __awaiter(this, void 0, void 0, function* () {
        let defaultTheme;
        try {
            defaultTheme = require('@kui-shell/client/config.d/style.json').defaultTheme;
        }
        catch (err) {
            console.log('using default defaultTheme');
        }
        if (!defaultTheme) {
            console.error('theme bug: the theme does not set a default theme');
            defaultTheme = yield uiThemes()
                .then(themeSets => themeSets[0].themes[0].name)
                .catch(() => {
                throw new Error('SEVERE theme bug: no theme found');
            });
            if (!defaultTheme) {
                throw new Error('SEVERE theme bug: no theme found');
            }
        }
        debug('using default theme %s', defaultTheme);
        return defaultTheme;
    });
}
export default getDefault;
//# sourceMappingURL=default.js.map