// Code generated by protoc-gen-go. DO NOT EDIT.
// source: quic-trace.proto

package pb

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

type FrameType int32

const (
	FrameType_UNKNOWN_FRAME    FrameType = 0
	FrameType_STREAM           FrameType = 1
	FrameType_ACK              FrameType = 2
	FrameType_RESET_STREAM     FrameType = 3
	FrameType_CONNECTION_CLOSE FrameType = 4
	FrameType_MAX_DATA         FrameType = 5
	FrameType_MAX_STREAM_DATA  FrameType = 6
	FrameType_PING             FrameType = 7
	FrameType_BLOCKED          FrameType = 8
	FrameType_STREAM_BLOCKED   FrameType = 9
	FrameType_PADDING          FrameType = 10
	FrameType_CRYPTO           FrameType = 11
)

var FrameType_name = map[int32]string{
	0:  "UNKNOWN_FRAME",
	1:  "STREAM",
	2:  "ACK",
	3:  "RESET_STREAM",
	4:  "CONNECTION_CLOSE",
	5:  "MAX_DATA",
	6:  "MAX_STREAM_DATA",
	7:  "PING",
	8:  "BLOCKED",
	9:  "STREAM_BLOCKED",
	10: "PADDING",
	11: "CRYPTO",
}

var FrameType_value = map[string]int32{
	"UNKNOWN_FRAME":    0,
	"STREAM":           1,
	"ACK":              2,
	"RESET_STREAM":     3,
	"CONNECTION_CLOSE": 4,
	"MAX_DATA":         5,
	"MAX_STREAM_DATA":  6,
	"PING":             7,
	"BLOCKED":          8,
	"STREAM_BLOCKED":   9,
	"PADDING":          10,
	"CRYPTO":           11,
}

func (x FrameType) Enum() *FrameType {
	p := new(FrameType)
	*p = x
	return p
}

func (x FrameType) String() string {
	return proto.EnumName(FrameType_name, int32(x))
}

func (x *FrameType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FrameType_value, data, "FrameType")
	if err != nil {
		return err
	}
	*x = FrameType(value)
	return nil
}

func (FrameType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{0}
}

// Metadata for CONNECTION_CLOSE frames.
// Close_type will indicate whether the close is a Google QUIC close,
// IETF QUIC Transport CONNECTION CLOSE, or IETF QUIC Application
// Connection Close, frame.
type CloseType int32

const (
	CloseType_GOOGLE_QUIC_CONNECTION_CLOSE           CloseType = 0
	CloseType_IETF_QUIC_TRANSPORT_CONNECTION_CLOSE   CloseType = 1
	CloseType_IETF_QUIC_APPLICATION_CONNECTION_CLOSE CloseType = 2
)

var CloseType_name = map[int32]string{
	0: "GOOGLE_QUIC_CONNECTION_CLOSE",
	1: "IETF_QUIC_TRANSPORT_CONNECTION_CLOSE",
	2: "IETF_QUIC_APPLICATION_CONNECTION_CLOSE",
}

var CloseType_value = map[string]int32{
	"GOOGLE_QUIC_CONNECTION_CLOSE":           0,
	"IETF_QUIC_TRANSPORT_CONNECTION_CLOSE":   1,
	"IETF_QUIC_APPLICATION_CONNECTION_CLOSE": 2,
}

func (x CloseType) Enum() *CloseType {
	p := new(CloseType)
	*p = x
	return p
}

func (x CloseType) String() string {
	return proto.EnumName(CloseType_name, int32(x))
}

func (x *CloseType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(CloseType_value, data, "CloseType")
	if err != nil {
		return err
	}
	*x = CloseType(value)
	return nil
}

func (CloseType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{1}
}

type EncryptionLevel int32

const (
	EncryptionLevel_ENCRYPTION_UNKNOWN   EncryptionLevel = 0
	EncryptionLevel_ENCRYPTION_INITIAL   EncryptionLevel = 1
	EncryptionLevel_ENCRYPTION_0RTT      EncryptionLevel = 2
	EncryptionLevel_ENCRYPTION_1RTT      EncryptionLevel = 3
	EncryptionLevel_ENCRYPTION_HANDSHAKE EncryptionLevel = 4
)

var EncryptionLevel_name = map[int32]string{
	0: "ENCRYPTION_UNKNOWN",
	1: "ENCRYPTION_INITIAL",
	2: "ENCRYPTION_0RTT",
	3: "ENCRYPTION_1RTT",
	4: "ENCRYPTION_HANDSHAKE",
}

var EncryptionLevel_value = map[string]int32{
	"ENCRYPTION_UNKNOWN":   0,
	"ENCRYPTION_INITIAL":   1,
	"ENCRYPTION_0RTT":      2,
	"ENCRYPTION_1RTT":      3,
	"ENCRYPTION_HANDSHAKE": 4,
}

func (x EncryptionLevel) Enum() *EncryptionLevel {
	p := new(EncryptionLevel)
	*p = x
	return p
}

func (x EncryptionLevel) String() string {
	return proto.EnumName(EncryptionLevel_name, int32(x))
}

func (x *EncryptionLevel) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EncryptionLevel_value, data, "EncryptionLevel")
	if err != nil {
		return err
	}
	*x = EncryptionLevel(value)
	return nil
}

func (EncryptionLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{2}
}

type EventType int32

const (
	EventType_UNKNOWN_EVENT   EventType = 0
	EventType_PACKET_SENT     EventType = 1
	EventType_PACKET_RECEIVED EventType = 2
	EventType_PACKET_LOST     EventType = 3
	// An APPLICATION_LIMITED event occurs when the sender is capable of sending
	// more data and tries to send it, but discovers that it does not have any
	// outstanding data to send.  Such events are important to some congestion
	// control algorithms (for example, BBR) since they are trying to measure the
	// largest achievable throughput, but it is impossible to measure it when the
	// application does not send anything.
	EventType_APPLICATION_LIMITED EventType = 4
	// Record when external information about expected network conditions
	// (available bandwidth, RTT, congestion window, etc) is supplied to the
	// sender.
	EventType_EXTERNAL_PARAMETERS EventType = 5
)

var EventType_name = map[int32]string{
	0: "UNKNOWN_EVENT",
	1: "PACKET_SENT",
	2: "PACKET_RECEIVED",
	3: "PACKET_LOST",
	4: "APPLICATION_LIMITED",
	5: "EXTERNAL_PARAMETERS",
}

var EventType_value = map[string]int32{
	"UNKNOWN_EVENT":       0,
	"PACKET_SENT":         1,
	"PACKET_RECEIVED":     2,
	"PACKET_LOST":         3,
	"APPLICATION_LIMITED": 4,
	"EXTERNAL_PARAMETERS": 5,
}

func (x EventType) Enum() *EventType {
	p := new(EventType)
	*p = x
	return p
}

func (x EventType) String() string {
	return proto.EnumName(EventType_name, int32(x))
}

func (x *EventType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(EventType_value, data, "EventType")
	if err != nil {
		return err
	}
	*x = EventType(value)
	return nil
}

func (EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{3}
}

type TransmissionReason int32

const (
	// Indicates that there was not any particular special reason the packet was
	// sent.
	TransmissionReason_NORMAL_TRANSMISSION TransmissionReason = 0
	// Indicates that the packet sent is a tail loss probe, cf.
	// https://tools.ietf.org/html/draft-ietf-quic-recovery-14#section-4.3.2
	TransmissionReason_TAIL_LOSS_PROBE TransmissionReason = 1
	// Indicates that the packet is sent due to retransmission timeout, cf
	// https://tools.ietf.org/html/draft-ietf-quic-recovery-14#section-4.3.3
	TransmissionReason_RTO_TRANSMISSION TransmissionReason = 2
	// Indicates that the packet is sent in order to probe whether there is extra
	// bandwidth available in cases where the sender needs an estimate of
	// available bandwidth, but the application does not provide enough data for
	// such estimate to become naturally available.  This is usually only used in
	// real-time protocols.
	TransmissionReason_PROBING_TRANSMISSION TransmissionReason = 3
)

var TransmissionReason_name = map[int32]string{
	0: "NORMAL_TRANSMISSION",
	1: "TAIL_LOSS_PROBE",
	2: "RTO_TRANSMISSION",
	3: "PROBING_TRANSMISSION",
}

var TransmissionReason_value = map[string]int32{
	"NORMAL_TRANSMISSION":  0,
	"TAIL_LOSS_PROBE":      1,
	"RTO_TRANSMISSION":     2,
	"PROBING_TRANSMISSION": 3,
}

func (x TransmissionReason) Enum() *TransmissionReason {
	p := new(TransmissionReason)
	*p = x
	return p
}

func (x TransmissionReason) String() string {
	return proto.EnumName(TransmissionReason_name, int32(x))
}

func (x *TransmissionReason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransmissionReason_value, data, "TransmissionReason")
	if err != nil {
		return err
	}
	*x = TransmissionReason(value)
	return nil
}

func (TransmissionReason) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{4}
}

// Metadata for STREAM frames.
type StreamFrameInfo struct {
	StreamId             *uint64  `protobuf:"varint,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	Fin                  *bool    `protobuf:"varint,2,opt,name=fin" json:"fin,omitempty"`
	Length               *uint64  `protobuf:"varint,3,opt,name=length" json:"length,omitempty"`
	Offset               *uint64  `protobuf:"varint,4,opt,name=offset" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamFrameInfo) Reset()         { *m = StreamFrameInfo{} }
func (m *StreamFrameInfo) String() string { return proto.CompactTextString(m) }
func (*StreamFrameInfo) ProtoMessage()    {}
func (*StreamFrameInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{0}
}

func (m *StreamFrameInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamFrameInfo.Unmarshal(m, b)
}
func (m *StreamFrameInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamFrameInfo.Marshal(b, m, deterministic)
}
func (m *StreamFrameInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamFrameInfo.Merge(m, src)
}
func (m *StreamFrameInfo) XXX_Size() int {
	return xxx_messageInfo_StreamFrameInfo.Size(m)
}
func (m *StreamFrameInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamFrameInfo.DiscardUnknown(m)
}

var xxx_messageInfo_StreamFrameInfo proto.InternalMessageInfo

func (m *StreamFrameInfo) GetStreamId() uint64 {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return 0
}

func (m *StreamFrameInfo) GetFin() bool {
	if m != nil && m.Fin != nil {
		return *m.Fin
	}
	return false
}

func (m *StreamFrameInfo) GetLength() uint64 {
	if m != nil && m.Length != nil {
		return *m.Length
	}
	return 0
}

func (m *StreamFrameInfo) GetOffset() uint64 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

// Metadata for CRYPTO frames.
type CryptoFrameInfo struct {
	Length               *uint64  `protobuf:"varint,1,opt,name=length" json:"length,omitempty"`
	Offset               *uint64  `protobuf:"varint,2,opt,name=offset" json:"offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CryptoFrameInfo) Reset()         { *m = CryptoFrameInfo{} }
func (m *CryptoFrameInfo) String() string { return proto.CompactTextString(m) }
func (*CryptoFrameInfo) ProtoMessage()    {}
func (*CryptoFrameInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{1}
}

func (m *CryptoFrameInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CryptoFrameInfo.Unmarshal(m, b)
}
func (m *CryptoFrameInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CryptoFrameInfo.Marshal(b, m, deterministic)
}
func (m *CryptoFrameInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CryptoFrameInfo.Merge(m, src)
}
func (m *CryptoFrameInfo) XXX_Size() int {
	return xxx_messageInfo_CryptoFrameInfo.Size(m)
}
func (m *CryptoFrameInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CryptoFrameInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CryptoFrameInfo proto.InternalMessageInfo

func (m *CryptoFrameInfo) GetLength() uint64 {
	if m != nil && m.Length != nil {
		return *m.Length
	}
	return 0
}

func (m *CryptoFrameInfo) GetOffset() uint64 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

// The intervals are closed, i.e. the interval represented here is
// [first_packet, last_packet].
type AckBlock struct {
	FirstPacket          *uint64  `protobuf:"varint,1,opt,name=first_packet,json=firstPacket" json:"first_packet,omitempty"`
	LastPacket           *uint64  `protobuf:"varint,2,opt,name=last_packet,json=lastPacket" json:"last_packet,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AckBlock) Reset()         { *m = AckBlock{} }
func (m *AckBlock) String() string { return proto.CompactTextString(m) }
func (*AckBlock) ProtoMessage()    {}
func (*AckBlock) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{2}
}

func (m *AckBlock) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AckBlock.Unmarshal(m, b)
}
func (m *AckBlock) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AckBlock.Marshal(b, m, deterministic)
}
func (m *AckBlock) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AckBlock.Merge(m, src)
}
func (m *AckBlock) XXX_Size() int {
	return xxx_messageInfo_AckBlock.Size(m)
}
func (m *AckBlock) XXX_DiscardUnknown() {
	xxx_messageInfo_AckBlock.DiscardUnknown(m)
}

var xxx_messageInfo_AckBlock proto.InternalMessageInfo

func (m *AckBlock) GetFirstPacket() uint64 {
	if m != nil && m.FirstPacket != nil {
		return *m.FirstPacket
	}
	return 0
}

func (m *AckBlock) GetLastPacket() uint64 {
	if m != nil && m.LastPacket != nil {
		return *m.LastPacket
	}
	return 0
}

// Metadata for ACK frames.
type AckInfo struct {
	AckedPackets         []*AckBlock `protobuf:"bytes,1,rep,name=acked_packets,json=ackedPackets" json:"acked_packets,omitempty"`
	AckDelayUs           *uint64     `protobuf:"varint,2,opt,name=ack_delay_us,json=ackDelayUs" json:"ack_delay_us,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *AckInfo) Reset()         { *m = AckInfo{} }
func (m *AckInfo) String() string { return proto.CompactTextString(m) }
func (*AckInfo) ProtoMessage()    {}
func (*AckInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{3}
}

func (m *AckInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AckInfo.Unmarshal(m, b)
}
func (m *AckInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AckInfo.Marshal(b, m, deterministic)
}
func (m *AckInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AckInfo.Merge(m, src)
}
func (m *AckInfo) XXX_Size() int {
	return xxx_messageInfo_AckInfo.Size(m)
}
func (m *AckInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AckInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AckInfo proto.InternalMessageInfo

func (m *AckInfo) GetAckedPackets() []*AckBlock {
	if m != nil {
		return m.AckedPackets
	}
	return nil
}

func (m *AckInfo) GetAckDelayUs() uint64 {
	if m != nil && m.AckDelayUs != nil {
		return *m.AckDelayUs
	}
	return 0
}

// Metadata for RST_STREAM frames.
type ResetStreamInfo struct {
	StreamId             *uint64  `protobuf:"varint,1,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	ApplicationErrorCode *uint32  `protobuf:"varint,2,opt,name=application_error_code,json=applicationErrorCode" json:"application_error_code,omitempty"`
	FinalOffset          *uint64  `protobuf:"varint,3,opt,name=final_offset,json=finalOffset" json:"final_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResetStreamInfo) Reset()         { *m = ResetStreamInfo{} }
func (m *ResetStreamInfo) String() string { return proto.CompactTextString(m) }
func (*ResetStreamInfo) ProtoMessage()    {}
func (*ResetStreamInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{4}
}

func (m *ResetStreamInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResetStreamInfo.Unmarshal(m, b)
}
func (m *ResetStreamInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResetStreamInfo.Marshal(b, m, deterministic)
}
func (m *ResetStreamInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResetStreamInfo.Merge(m, src)
}
func (m *ResetStreamInfo) XXX_Size() int {
	return xxx_messageInfo_ResetStreamInfo.Size(m)
}
func (m *ResetStreamInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ResetStreamInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ResetStreamInfo proto.InternalMessageInfo

func (m *ResetStreamInfo) GetStreamId() uint64 {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return 0
}

func (m *ResetStreamInfo) GetApplicationErrorCode() uint32 {
	if m != nil && m.ApplicationErrorCode != nil {
		return *m.ApplicationErrorCode
	}
	return 0
}

func (m *ResetStreamInfo) GetFinalOffset() uint64 {
	if m != nil && m.FinalOffset != nil {
		return *m.FinalOffset
	}
	return 0
}

// Metadata for CONNECTION_CLOSE/APPLICATION_CLOSE frames.
type CloseInfo struct {
	ErrorCode               *uint32    `protobuf:"varint,1,opt,name=error_code,json=errorCode" json:"error_code,omitempty"`
	ReasonPhrase            *string    `protobuf:"bytes,2,opt,name=reason_phrase,json=reasonPhrase" json:"reason_phrase,omitempty"`
	CloseType               *CloseType `protobuf:"varint,3,opt,name=close_type,json=closeType,enum=pb.CloseType" json:"close_type,omitempty"`
	TransportCloseFrameType *uint64    `protobuf:"varint,4,opt,name=transport_close_frame_type,json=transportCloseFrameType" json:"transport_close_frame_type,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}   `json:"-"`
	XXX_unrecognized        []byte     `json:"-"`
	XXX_sizecache           int32      `json:"-"`
}

func (m *CloseInfo) Reset()         { *m = CloseInfo{} }
func (m *CloseInfo) String() string { return proto.CompactTextString(m) }
func (*CloseInfo) ProtoMessage()    {}
func (*CloseInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{5}
}

func (m *CloseInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloseInfo.Unmarshal(m, b)
}
func (m *CloseInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloseInfo.Marshal(b, m, deterministic)
}
func (m *CloseInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloseInfo.Merge(m, src)
}
func (m *CloseInfo) XXX_Size() int {
	return xxx_messageInfo_CloseInfo.Size(m)
}
func (m *CloseInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CloseInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CloseInfo proto.InternalMessageInfo

func (m *CloseInfo) GetErrorCode() uint32 {
	if m != nil && m.ErrorCode != nil {
		return *m.ErrorCode
	}
	return 0
}

func (m *CloseInfo) GetReasonPhrase() string {
	if m != nil && m.ReasonPhrase != nil {
		return *m.ReasonPhrase
	}
	return ""
}

func (m *CloseInfo) GetCloseType() CloseType {
	if m != nil && m.CloseType != nil {
		return *m.CloseType
	}
	return CloseType_GOOGLE_QUIC_CONNECTION_CLOSE
}

func (m *CloseInfo) GetTransportCloseFrameType() uint64 {
	if m != nil && m.TransportCloseFrameType != nil {
		return *m.TransportCloseFrameType
	}
	return 0
}

// Metadata for MAX_DATA/MAX_STREAM_DATA frames.
type FlowControlInfo struct {
	MaxData              *uint64  `protobuf:"varint,1,opt,name=max_data,json=maxData" json:"max_data,omitempty"`
	StreamId             *uint64  `protobuf:"varint,2,opt,name=stream_id,json=streamId" json:"stream_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FlowControlInfo) Reset()         { *m = FlowControlInfo{} }
func (m *FlowControlInfo) String() string { return proto.CompactTextString(m) }
func (*FlowControlInfo) ProtoMessage()    {}
func (*FlowControlInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{6}
}

func (m *FlowControlInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FlowControlInfo.Unmarshal(m, b)
}
func (m *FlowControlInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FlowControlInfo.Marshal(b, m, deterministic)
}
func (m *FlowControlInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FlowControlInfo.Merge(m, src)
}
func (m *FlowControlInfo) XXX_Size() int {
	return xxx_messageInfo_FlowControlInfo.Size(m)
}
func (m *FlowControlInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_FlowControlInfo.DiscardUnknown(m)
}

var xxx_messageInfo_FlowControlInfo proto.InternalMessageInfo

func (m *FlowControlInfo) GetMaxData() uint64 {
	if m != nil && m.MaxData != nil {
		return *m.MaxData
	}
	return 0
}

func (m *FlowControlInfo) GetStreamId() uint64 {
	if m != nil && m.StreamId != nil {
		return *m.StreamId
	}
	return 0
}

// A message representing a frame, either sent or received.
type Frame struct {
	FrameType            *FrameType       `protobuf:"varint,1,opt,name=frame_type,json=frameType,enum=pb.FrameType" json:"frame_type,omitempty"`
	StreamFrameInfo      *StreamFrameInfo `protobuf:"bytes,2,opt,name=stream_frame_info,json=streamFrameInfo" json:"stream_frame_info,omitempty"`
	AckInfo              *AckInfo         `protobuf:"bytes,3,opt,name=ack_info,json=ackInfo" json:"ack_info,omitempty"`
	ResetStreamInfo      *ResetStreamInfo `protobuf:"bytes,4,opt,name=reset_stream_info,json=resetStreamInfo" json:"reset_stream_info,omitempty"`
	CloseInfo            *CloseInfo       `protobuf:"bytes,5,opt,name=close_info,json=closeInfo" json:"close_info,omitempty"`
	FlowControlInfo      *FlowControlInfo `protobuf:"bytes,6,opt,name=flow_control_info,json=flowControlInfo" json:"flow_control_info,omitempty"`
	CryptoFrameInfo      *CryptoFrameInfo `protobuf:"bytes,7,opt,name=crypto_frame_info,json=cryptoFrameInfo" json:"crypto_frame_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Frame) Reset()         { *m = Frame{} }
func (m *Frame) String() string { return proto.CompactTextString(m) }
func (*Frame) ProtoMessage()    {}
func (*Frame) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{7}
}

func (m *Frame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Frame.Unmarshal(m, b)
}
func (m *Frame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Frame.Marshal(b, m, deterministic)
}
func (m *Frame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Frame.Merge(m, src)
}
func (m *Frame) XXX_Size() int {
	return xxx_messageInfo_Frame.Size(m)
}
func (m *Frame) XXX_DiscardUnknown() {
	xxx_messageInfo_Frame.DiscardUnknown(m)
}

var xxx_messageInfo_Frame proto.InternalMessageInfo

func (m *Frame) GetFrameType() FrameType {
	if m != nil && m.FrameType != nil {
		return *m.FrameType
	}
	return FrameType_UNKNOWN_FRAME
}

func (m *Frame) GetStreamFrameInfo() *StreamFrameInfo {
	if m != nil {
		return m.StreamFrameInfo
	}
	return nil
}

func (m *Frame) GetAckInfo() *AckInfo {
	if m != nil {
		return m.AckInfo
	}
	return nil
}

func (m *Frame) GetResetStreamInfo() *ResetStreamInfo {
	if m != nil {
		return m.ResetStreamInfo
	}
	return nil
}

func (m *Frame) GetCloseInfo() *CloseInfo {
	if m != nil {
		return m.CloseInfo
	}
	return nil
}

func (m *Frame) GetFlowControlInfo() *FlowControlInfo {
	if m != nil {
		return m.FlowControlInfo
	}
	return nil
}

func (m *Frame) GetCryptoFrameInfo() *CryptoFrameInfo {
	if m != nil {
		return m.CryptoFrameInfo
	}
	return nil
}

// Metadata that represents transport stack's understanding of the current state
// of the transport channel.
type TransportState struct {
	MinRttUs *uint64 `protobuf:"varint,1,opt,name=min_rtt_us,json=minRttUs" json:"min_rtt_us,omitempty"`
	// Smoothed RTT, usually computed using EWMA.
	SmoothedRttUs *uint64 `protobuf:"varint,2,opt,name=smoothed_rtt_us,json=smoothedRttUs" json:"smoothed_rtt_us,omitempty"`
	// The latest RTT measureent available.
	LastRttUs     *uint64 `protobuf:"varint,3,opt,name=last_rtt_us,json=lastRttUs" json:"last_rtt_us,omitempty"`
	InFlightBytes *uint64 `protobuf:"varint,4,opt,name=in_flight_bytes,json=inFlightBytes" json:"in_flight_bytes,omitempty"`
	CwndBytes     *uint64 `protobuf:"varint,5,opt,name=cwnd_bytes,json=cwndBytes" json:"cwnd_bytes,omitempty"`
	// Pacing rate, in bits per second.
	PacingRateBps *uint64 `protobuf:"varint,6,opt,name=pacing_rate_bps,json=pacingRateBps" json:"pacing_rate_bps,omitempty"`
	// Any arbitrary information about congestion control state that is not
	// representable via parameters above.
	CongestionControlState *string  `protobuf:"bytes,7,opt,name=congestion_control_state,json=congestionControlState" json:"congestion_control_state,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *TransportState) Reset()         { *m = TransportState{} }
func (m *TransportState) String() string { return proto.CompactTextString(m) }
func (*TransportState) ProtoMessage()    {}
func (*TransportState) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{8}
}

func (m *TransportState) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TransportState.Unmarshal(m, b)
}
func (m *TransportState) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TransportState.Marshal(b, m, deterministic)
}
func (m *TransportState) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TransportState.Merge(m, src)
}
func (m *TransportState) XXX_Size() int {
	return xxx_messageInfo_TransportState.Size(m)
}
func (m *TransportState) XXX_DiscardUnknown() {
	xxx_messageInfo_TransportState.DiscardUnknown(m)
}

var xxx_messageInfo_TransportState proto.InternalMessageInfo

func (m *TransportState) GetMinRttUs() uint64 {
	if m != nil && m.MinRttUs != nil {
		return *m.MinRttUs
	}
	return 0
}

func (m *TransportState) GetSmoothedRttUs() uint64 {
	if m != nil && m.SmoothedRttUs != nil {
		return *m.SmoothedRttUs
	}
	return 0
}

func (m *TransportState) GetLastRttUs() uint64 {
	if m != nil && m.LastRttUs != nil {
		return *m.LastRttUs
	}
	return 0
}

func (m *TransportState) GetInFlightBytes() uint64 {
	if m != nil && m.InFlightBytes != nil {
		return *m.InFlightBytes
	}
	return 0
}

func (m *TransportState) GetCwndBytes() uint64 {
	if m != nil && m.CwndBytes != nil {
		return *m.CwndBytes
	}
	return 0
}

func (m *TransportState) GetPacingRateBps() uint64 {
	if m != nil && m.PacingRateBps != nil {
		return *m.PacingRateBps
	}
	return 0
}

func (m *TransportState) GetCongestionControlState() string {
	if m != nil && m.CongestionControlState != nil {
		return *m.CongestionControlState
	}
	return ""
}

// Documents external network parameters supplied to the sender.  Typically not
// all of those would be supplied (e.g. if bandwidth and RTT are supplied, you
// can infer the suggested CWND), but there are no restrictions on which fields
// may or may not be set.
type ExternalNetworkParameters struct {
	BandwidthBps         *uint64  `protobuf:"varint,1,opt,name=bandwidth_bps,json=bandwidthBps" json:"bandwidth_bps,omitempty"`
	RttUs                *uint64  `protobuf:"varint,2,opt,name=rtt_us,json=rttUs" json:"rtt_us,omitempty"`
	CwndBytes            *uint64  `protobuf:"varint,3,opt,name=cwnd_bytes,json=cwndBytes" json:"cwnd_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExternalNetworkParameters) Reset()         { *m = ExternalNetworkParameters{} }
func (m *ExternalNetworkParameters) String() string { return proto.CompactTextString(m) }
func (*ExternalNetworkParameters) ProtoMessage()    {}
func (*ExternalNetworkParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{9}
}

func (m *ExternalNetworkParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExternalNetworkParameters.Unmarshal(m, b)
}
func (m *ExternalNetworkParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExternalNetworkParameters.Marshal(b, m, deterministic)
}
func (m *ExternalNetworkParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExternalNetworkParameters.Merge(m, src)
}
func (m *ExternalNetworkParameters) XXX_Size() int {
	return xxx_messageInfo_ExternalNetworkParameters.Size(m)
}
func (m *ExternalNetworkParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ExternalNetworkParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ExternalNetworkParameters proto.InternalMessageInfo

func (m *ExternalNetworkParameters) GetBandwidthBps() uint64 {
	if m != nil && m.BandwidthBps != nil {
		return *m.BandwidthBps
	}
	return 0
}

func (m *ExternalNetworkParameters) GetRttUs() uint64 {
	if m != nil && m.RttUs != nil {
		return *m.RttUs
	}
	return 0
}

func (m *ExternalNetworkParameters) GetCwndBytes() uint64 {
	if m != nil && m.CwndBytes != nil {
		return *m.CwndBytes
	}
	return 0
}

// An event that has occurred over duration of the connection.
type Event struct {
	TimeUs          *uint64          `protobuf:"varint,1,opt,name=time_us,json=timeUs" json:"time_us,omitempty"`
	EventType       *EventType       `protobuf:"varint,2,opt,name=event_type,json=eventType,enum=pb.EventType" json:"event_type,omitempty"`
	PacketNumber    *uint64          `protobuf:"varint,3,opt,name=packet_number,json=packetNumber" json:"packet_number,omitempty"`
	Frames          []*Frame         `protobuf:"bytes,4,rep,name=frames" json:"frames,omitempty"`
	PacketSize      *uint64          `protobuf:"varint,5,opt,name=packet_size,json=packetSize" json:"packet_size,omitempty"`
	EncryptionLevel *EncryptionLevel `protobuf:"varint,6,opt,name=encryption_level,json=encryptionLevel,enum=pb.EncryptionLevel" json:"encryption_level,omitempty"`
	// State of the transport stack after the event has happened.
	TransportState *TransportState `protobuf:"bytes,7,opt,name=transport_state,json=transportState" json:"transport_state,omitempty"`
	// For event_type = EXTERNAL_PARAMETERS, record parameters specified.
	ExternalNetworkParameters *ExternalNetworkParameters `protobuf:"bytes,8,opt,name=external_network_parameters,json=externalNetworkParameters" json:"external_network_parameters,omitempty"`
	// For sent packets, indicate if there is a special reason for why the packet
	// in question was transmitted.
	TransmissionReason   *TransmissionReason `protobuf:"varint,9,opt,name=transmission_reason,json=transmissionReason,enum=pb.TransmissionReason,def=0" json:"transmission_reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *Event) Reset()         { *m = Event{} }
func (m *Event) String() string { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()    {}
func (*Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{10}
}

func (m *Event) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Event.Unmarshal(m, b)
}
func (m *Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Event.Marshal(b, m, deterministic)
}
func (m *Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Event.Merge(m, src)
}
func (m *Event) XXX_Size() int {
	return xxx_messageInfo_Event.Size(m)
}
func (m *Event) XXX_DiscardUnknown() {
	xxx_messageInfo_Event.DiscardUnknown(m)
}

var xxx_messageInfo_Event proto.InternalMessageInfo

const Default_Event_TransmissionReason TransmissionReason = TransmissionReason_NORMAL_TRANSMISSION

func (m *Event) GetTimeUs() uint64 {
	if m != nil && m.TimeUs != nil {
		return *m.TimeUs
	}
	return 0
}

func (m *Event) GetEventType() EventType {
	if m != nil && m.EventType != nil {
		return *m.EventType
	}
	return EventType_UNKNOWN_EVENT
}

func (m *Event) GetPacketNumber() uint64 {
	if m != nil && m.PacketNumber != nil {
		return *m.PacketNumber
	}
	return 0
}

func (m *Event) GetFrames() []*Frame {
	if m != nil {
		return m.Frames
	}
	return nil
}

func (m *Event) GetPacketSize() uint64 {
	if m != nil && m.PacketSize != nil {
		return *m.PacketSize
	}
	return 0
}

func (m *Event) GetEncryptionLevel() EncryptionLevel {
	if m != nil && m.EncryptionLevel != nil {
		return *m.EncryptionLevel
	}
	return EncryptionLevel_ENCRYPTION_UNKNOWN
}

func (m *Event) GetTransportState() *TransportState {
	if m != nil {
		return m.TransportState
	}
	return nil
}

func (m *Event) GetExternalNetworkParameters() *ExternalNetworkParameters {
	if m != nil {
		return m.ExternalNetworkParameters
	}
	return nil
}

func (m *Event) GetTransmissionReason() TransmissionReason {
	if m != nil && m.TransmissionReason != nil {
		return *m.TransmissionReason
	}
	return Default_Event_TransmissionReason
}

type Trace struct {
	// QUIC version tag, as represented on wire.  Should be always 4 bytes long.
	ProtocolVersion []byte `protobuf:"bytes,1,opt,name=protocol_version,json=protocolVersion" json:"protocol_version,omitempty"`
	// Source and destination connection ID.  If multiple connection IDs are used,
	// record the first one used with short-form header.
	SourceConnectionId      []byte   `protobuf:"bytes,2,opt,name=source_connection_id,json=sourceConnectionId" json:"source_connection_id,omitempty"`
	DestinationConnectionId []byte   `protobuf:"bytes,3,opt,name=destination_connection_id,json=destinationConnectionId" json:"destination_connection_id,omitempty"`
	Events                  []*Event `protobuf:"bytes,4,rep,name=events" json:"events,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *Trace) Reset()         { *m = Trace{} }
func (m *Trace) String() string { return proto.CompactTextString(m) }
func (*Trace) ProtoMessage()    {}
func (*Trace) Descriptor() ([]byte, []int) {
	return fileDescriptor_79ecf15e0416742d, []int{11}
}

func (m *Trace) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Trace.Unmarshal(m, b)
}
func (m *Trace) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Trace.Marshal(b, m, deterministic)
}
func (m *Trace) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Trace.Merge(m, src)
}
func (m *Trace) XXX_Size() int {
	return xxx_messageInfo_Trace.Size(m)
}
func (m *Trace) XXX_DiscardUnknown() {
	xxx_messageInfo_Trace.DiscardUnknown(m)
}

var xxx_messageInfo_Trace proto.InternalMessageInfo

func (m *Trace) GetProtocolVersion() []byte {
	if m != nil {
		return m.ProtocolVersion
	}
	return nil
}

func (m *Trace) GetSourceConnectionId() []byte {
	if m != nil {
		return m.SourceConnectionId
	}
	return nil
}

func (m *Trace) GetDestinationConnectionId() []byte {
	if m != nil {
		return m.DestinationConnectionId
	}
	return nil
}

func (m *Trace) GetEvents() []*Event {
	if m != nil {
		return m.Events
	}
	return nil
}

func init() {
	proto.RegisterEnum("pb.FrameType", FrameType_name, FrameType_value)
	proto.RegisterEnum("pb.CloseType", CloseType_name, CloseType_value)
	proto.RegisterEnum("pb.EncryptionLevel", EncryptionLevel_name, EncryptionLevel_value)
	proto.RegisterEnum("pb.EventType", EventType_name, EventType_value)
	proto.RegisterEnum("pb.TransmissionReason", TransmissionReason_name, TransmissionReason_value)
	proto.RegisterType((*StreamFrameInfo)(nil), "pb.StreamFrameInfo")
	proto.RegisterType((*CryptoFrameInfo)(nil), "pb.CryptoFrameInfo")
	proto.RegisterType((*AckBlock)(nil), "pb.AckBlock")
	proto.RegisterType((*AckInfo)(nil), "pb.AckInfo")
	proto.RegisterType((*ResetStreamInfo)(nil), "pb.ResetStreamInfo")
	proto.RegisterType((*CloseInfo)(nil), "pb.CloseInfo")
	proto.RegisterType((*FlowControlInfo)(nil), "pb.FlowControlInfo")
	proto.RegisterType((*Frame)(nil), "pb.Frame")
	proto.RegisterType((*TransportState)(nil), "pb.TransportState")
	proto.RegisterType((*ExternalNetworkParameters)(nil), "pb.ExternalNetworkParameters")
	proto.RegisterType((*Event)(nil), "pb.Event")
	proto.RegisterType((*Trace)(nil), "pb.Trace")
}

func init() { proto.RegisterFile("quic-trace.proto", fileDescriptor_79ecf15e0416742d) }

var fileDescriptor_79ecf15e0416742d = []byte{
	// 1432 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x56, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xae, 0xf3, 0x9f, 0x93, 0xa4, 0x76, 0xa7, 0xa5, 0x4d, 0xd9, 0x5d, 0xe8, 0x06, 0x54, 0x95,
	0x0a, 0x56, 0xbb, 0x15, 0x17, 0x68, 0x57, 0x62, 0xe5, 0x26, 0x6e, 0xd7, 0x6a, 0x6a, 0x87, 0x89,
	0xbb, 0x2c, 0x12, 0x30, 0x72, 0x9d, 0x49, 0x6b, 0xd5, 0xb1, 0x8d, 0x3d, 0x6d, 0xb7, 0x7b, 0x8b,
	0xd0, 0x5e, 0xf2, 0x08, 0xbc, 0x07, 0x97, 0xf0, 0x44, 0xbc, 0x01, 0x9a, 0x19, 0x3b, 0x7f, 0x65,
	0xc5, 0x9d, 0xe7, 0x3b, 0xdf, 0xf9, 0x99, 0xef, 0x9c, 0x33, 0x09, 0x68, 0xbf, 0x5c, 0xfb, 0xde,
	0x57, 0x2c, 0x71, 0x3d, 0xfa, 0x24, 0x4e, 0x22, 0x16, 0xa1, 0x42, 0x7c, 0xde, 0x89, 0x41, 0x1d,
	0xb2, 0x84, 0xba, 0x93, 0xa3, 0xc4, 0x9d, 0x50, 0x33, 0x1c, 0x47, 0xe8, 0x01, 0xd4, 0x53, 0x01,
	0x11, 0x7f, 0xd4, 0x56, 0x76, 0x94, 0xbd, 0x12, 0xae, 0x49, 0xc0, 0x1c, 0x21, 0x0d, 0x8a, 0x63,
	0x3f, 0x6c, 0x17, 0x76, 0x94, 0xbd, 0x1a, 0xe6, 0x9f, 0x68, 0x13, 0x2a, 0x01, 0x0d, 0x2f, 0xd8,
	0x65, 0xbb, 0x28, 0xb8, 0xd9, 0x89, 0xe3, 0xd1, 0x78, 0x9c, 0x52, 0xd6, 0x2e, 0x49, 0x5c, 0x9e,
	0x3a, 0x3a, 0xa8, 0xdd, 0xe4, 0x2e, 0x66, 0xd1, 0x2c, 0xe3, 0x2c, 0x84, 0xf2, 0x81, 0x10, 0x85,
	0x85, 0x10, 0x16, 0xd4, 0x74, 0xef, 0xea, 0x30, 0x88, 0xbc, 0x2b, 0xf4, 0x18, 0x9a, 0x63, 0x3f,
	0x49, 0x19, 0x89, 0x5d, 0xef, 0x8a, 0xb2, 0x2c, 0x42, 0x43, 0x60, 0x03, 0x01, 0xa1, 0x4f, 0xa1,
	0x11, 0xb8, 0x33, 0x86, 0x8c, 0x05, 0x1c, 0x92, 0x84, 0xce, 0xcf, 0x50, 0xd5, 0xbd, 0x2b, 0x51,
	0xca, 0x33, 0x68, 0x71, 0x6c, 0x94, 0x91, 0xd3, 0xb6, 0xb2, 0x53, 0xdc, 0x6b, 0x1c, 0x34, 0x9f,
	0xc4, 0xe7, 0x4f, 0xf2, 0x9c, 0xb8, 0x29, 0x28, 0xd2, 0x39, 0x45, 0x3b, 0xc0, 0xcf, 0x64, 0x44,
	0x03, 0xf7, 0x8e, 0x5c, 0xa7, 0x79, 0x7c, 0xd7, 0xbb, 0xea, 0x71, 0xe8, 0x2c, 0xed, 0xbc, 0x57,
	0x40, 0xc5, 0x34, 0xa5, 0x4c, 0x4a, 0xfd, 0xff, 0x2a, 0x7f, 0x0d, 0x9b, 0x6e, 0x1c, 0x07, 0xbe,
	0xe7, 0x32, 0x3f, 0x0a, 0x09, 0x4d, 0x92, 0x28, 0x21, 0x5e, 0x34, 0xa2, 0x22, 0x78, 0x0b, 0x6f,
	0xcc, 0x59, 0x0d, 0x6e, 0xec, 0x46, 0x23, 0x2a, 0xa5, 0x08, 0xdd, 0x80, 0x64, 0xa2, 0x15, 0x73,
	0x29, 0x42, 0x37, 0xb0, 0xa5, 0x72, 0x7f, 0x2a, 0x50, 0xef, 0x06, 0x51, 0x2a, 0x75, 0x7f, 0x04,
	0x30, 0x17, 0x5a, 0x11, 0xa1, 0xeb, 0x74, 0x1a, 0xef, 0x33, 0x68, 0x25, 0xd4, 0x4d, 0xa3, 0x90,
	0xc4, 0x97, 0x89, 0x9b, 0xca, 0xe4, 0x75, 0xdc, 0x94, 0xe0, 0x40, 0x60, 0xe8, 0x4b, 0x00, 0x8f,
	0x07, 0x24, 0xec, 0x2e, 0xa6, 0x22, 0xe5, 0xea, 0x41, 0x8b, 0xab, 0x25, 0xd2, 0x38, 0x77, 0x31,
	0xc5, 0x75, 0x2f, 0xff, 0x44, 0x2f, 0xe0, 0x63, 0x96, 0xb8, 0x61, 0x1a, 0x47, 0x09, 0x23, 0xd2,
	0x6f, 0xcc, 0xc7, 0x40, 0x7a, 0xcb, 0x41, 0xd9, 0x9a, 0x32, 0x44, 0x08, 0x31, 0x26, 0xdc, 0xb9,
	0x63, 0x82, 0x7a, 0x14, 0x44, 0xb7, 0xdd, 0x28, 0x64, 0x49, 0x14, 0x88, 0x1b, 0x6c, 0x43, 0x6d,
	0xe2, 0xbe, 0x25, 0x23, 0x97, 0xb9, 0x99, 0x88, 0xd5, 0x89, 0xfb, 0xb6, 0xe7, 0x32, 0x77, 0x51,
	0xe0, 0xc2, 0xa2, 0xc0, 0x9d, 0xdf, 0x8b, 0x50, 0x16, 0x81, 0x79, 0xfd, 0x73, 0x15, 0x28, 0xb3,
	0xfa, 0xa7, 0x79, 0x71, 0x7d, 0x9c, 0x7f, 0xa2, 0x97, 0xb0, 0x96, 0x05, 0x95, 0x4e, 0x7e, 0x38,
	0x8e, 0x44, 0xf0, 0xc6, 0xc1, 0x3a, 0x77, 0x5a, 0xda, 0x25, 0xac, 0xa6, 0x4b, 0xcb, 0xb5, 0x0b,
	0x35, 0x3e, 0x2c, 0xc2, 0xaf, 0x28, 0xfc, 0x1a, 0xd9, 0x68, 0x09, 0x7e, 0xd5, 0xcd, 0xe6, 0xf0,
	0x25, 0xac, 0x25, 0x7c, 0x62, 0x48, 0x7e, 0x07, 0xee, 0x50, 0x9a, 0x25, 0x5a, 0x1a, 0x27, 0xac,
	0x26, 0x4b, 0xf3, 0x35, 0xed, 0x8b, 0xf0, 0x2c, 0x0b, 0xcf, 0x59, 0x5f, 0x84, 0x8f, 0xec, 0x4b,
	0x9e, 0x6e, 0x1c, 0x44, 0xb7, 0xc4, 0x93, 0xda, 0x4a, 0xa7, 0xca, 0x2c, 0xdd, 0x92, 0xee, 0x58,
	0x1d, 0x2f, 0x35, 0xe2, 0x25, 0xac, 0x79, 0x62, 0xab, 0xe7, 0x85, 0xa9, 0xce, 0x02, 0x2c, 0xad,
	0x3c, 0x56, 0xbd, 0x45, 0xa0, 0xf3, 0x47, 0x01, 0x56, 0x9d, 0xbc, 0xf1, 0x43, 0xe6, 0x32, 0x8a,
	0x1e, 0x02, 0x4c, 0xfc, 0x90, 0x24, 0x8c, 0xf1, 0xb5, 0xca, 0x76, 0x64, 0xe2, 0x87, 0x98, 0xb1,
	0xb3, 0x14, 0xed, 0x82, 0x9a, 0x4e, 0xa2, 0x88, 0x5d, 0xd2, 0x51, 0x4e, 0x91, 0x5d, 0x6e, 0xe5,
	0xb0, 0xe4, 0x7d, 0x92, 0x6d, 0x7f, 0xc6, 0x91, 0x4b, 0x51, 0xe7, 0xd0, 0x34, 0x8e, 0x1f, 0x92,
	0x71, 0xe0, 0x5f, 0x5c, 0x32, 0x72, 0x7e, 0xc7, 0x68, 0x9a, 0xcd, 0x61, 0xcb, 0x0f, 0x8f, 0x04,
	0x7a, 0xc8, 0x41, 0xbe, 0x2c, 0xde, 0x6d, 0x38, 0xca, 0x28, 0x65, 0x19, 0x86, 0x23, 0xd2, 0xbc,
	0x0b, 0x6a, 0xec, 0x7a, 0x7e, 0x78, 0x41, 0x12, 0x97, 0x51, 0x72, 0x1e, 0xa7, 0x42, 0xbf, 0x12,
	0x6e, 0x49, 0x18, 0xbb, 0x8c, 0x1e, 0xc6, 0x29, 0xfa, 0x06, 0xda, 0x5e, 0x14, 0x5e, 0xd0, 0x54,
	0x6c, 0x76, 0xae, 0x77, 0xca, 0x2f, 0x2c, 0xf4, 0xaa, 0xe3, 0xcd, 0x99, 0x3d, 0x53, 0x58, 0xc8,
	0xd1, 0xb9, 0x81, 0x6d, 0xe3, 0x2d, 0xa3, 0x49, 0xe8, 0x06, 0x16, 0x65, 0xb7, 0x51, 0x72, 0x35,
	0x70, 0xb9, 0x7c, 0x8c, 0x26, 0x29, 0xdf, 0xd5, 0x73, 0x37, 0x1c, 0xdd, 0xfa, 0x23, 0x76, 0x29,
	0x92, 0x4b, 0xb9, 0x9a, 0x53, 0x90, 0xe7, 0xfe, 0x08, 0x2a, 0x0b, 0x4a, 0x95, 0x13, 0xa1, 0xc0,
	0xe2, 0xcd, 0x8a, 0x4b, 0x37, 0xeb, 0xfc, 0x53, 0x84, 0xb2, 0x71, 0x43, 0x43, 0x86, 0xb6, 0xa0,
	0xca, 0xfc, 0x09, 0x9d, 0x75, 0xa3, 0xc2, 0x8f, 0x67, 0x29, 0x1f, 0x36, 0xca, 0x19, 0x72, 0x89,
	0x0a, 0xb3, 0x25, 0x12, 0x7e, 0x72, 0x89, 0x68, 0xfe, 0xc9, 0x6b, 0x95, 0xaf, 0x2b, 0x09, 0xaf,
	0x27, 0xe7, 0x34, 0xc9, 0x52, 0x36, 0x25, 0x68, 0x09, 0x0c, 0x3d, 0x86, 0x8a, 0x98, 0x24, 0xde,
	0x0d, 0xfe, 0x02, 0xd7, 0xa7, 0x3b, 0x89, 0x33, 0x03, 0x7f, 0xd7, 0xb3, 0x38, 0xa9, 0xff, 0x8e,
	0x66, 0x2d, 0x01, 0x09, 0x0d, 0xfd, 0x77, 0x14, 0x7d, 0x0b, 0x1a, 0x0d, 0xc5, 0xa0, 0x71, 0xad,
	0x03, 0x7a, 0x43, 0x03, 0xd1, 0x94, 0x55, 0x39, 0x93, 0xc6, 0xd4, 0xd6, 0xe7, 0x26, 0xac, 0xd2,
	0x45, 0x00, 0xbd, 0x00, 0x75, 0xf6, 0x5a, 0xcd, 0x5a, 0xd4, 0x38, 0x40, 0xdc, 0x7d, 0x71, 0x5a,
	0xf1, 0x2a, 0x5b, 0x9c, 0xde, 0x9f, 0xe0, 0x01, 0xcd, 0xda, 0x45, 0x42, 0xd9, 0x2f, 0x12, 0x4f,
	0x1b, 0xd6, 0xae, 0x89, 0x40, 0x8f, 0x44, 0x1d, 0x1f, 0xea, 0x2a, 0xde, 0xa6, 0x1f, 0x6c, 0xf8,
	0x8f, 0xb0, 0x2e, 0x12, 0x4e, 0xfc, 0x34, 0xe5, 0xb7, 0x93, 0x8f, 0x72, 0xbb, 0x2e, 0xae, 0xb7,
	0x39, 0xad, 0x2f, 0x33, 0x63, 0x61, 0x7d, 0xbe, 0x6e, 0xd9, 0xf8, 0x54, 0xef, 0x13, 0x07, 0xeb,
	0xd6, 0xf0, 0xd4, 0x1c, 0x0e, 0x4d, 0xdb, 0xc2, 0x88, 0xdd, 0x23, 0x76, 0xfe, 0x56, 0xa0, 0xec,
	0xf0, 0xbf, 0x0a, 0xe8, 0x0b, 0xd0, 0xc4, 0xbf, 0x05, 0x2f, 0x0a, 0xc8, 0x0d, 0x4d, 0x38, 0x47,
	0x34, 0xbf, 0x89, 0xd5, 0x1c, 0x7f, 0x2d, 0x61, 0xf4, 0x14, 0x36, 0xd2, 0xe8, 0x3a, 0xf1, 0x28,
	0x1f, 0xeb, 0x90, 0x7a, 0x42, 0xf5, 0xec, 0xf1, 0x6d, 0x62, 0x24, 0x6d, 0xdd, 0xa9, 0xc9, 0x1c,
	0xa1, 0xe7, 0xb0, 0x3d, 0xe2, 0x93, 0x1e, 0xba, 0xf9, 0x36, 0xcc, 0xb9, 0x15, 0x85, 0xdb, 0xd6,
	0x1c, 0x61, 0xc1, 0xf7, 0x31, 0x54, 0xc4, 0x48, 0x2d, 0x0c, 0x88, 0x98, 0x37, 0x9c, 0x19, 0xf6,
	0xff, 0x52, 0xa0, 0x3e, 0x7d, 0xc6, 0xd1, 0x1a, 0xb4, 0xce, 0xac, 0x13, 0xcb, 0xfe, 0xde, 0x22,
	0x47, 0x58, 0x3f, 0x35, 0xb4, 0x15, 0x04, 0x50, 0x19, 0x3a, 0xd8, 0xd0, 0x4f, 0x35, 0x05, 0x55,
	0xa1, 0xa8, 0x77, 0x4f, 0xb4, 0x02, 0xd2, 0xa0, 0x89, 0x8d, 0xa1, 0xe1, 0x90, 0xcc, 0x54, 0x44,
	0x1b, 0xa0, 0x75, 0x6d, 0xcb, 0x32, 0xba, 0x8e, 0x69, 0x5b, 0xa4, 0xdb, 0xb7, 0x87, 0x86, 0x56,
	0x42, 0x4d, 0xa8, 0x9d, 0xea, 0x6f, 0x48, 0x4f, 0x77, 0x74, 0xad, 0x8c, 0xd6, 0x41, 0xe5, 0x27,
	0xe9, 0x23, 0xc1, 0x0a, 0xaa, 0x41, 0x69, 0x60, 0x5a, 0xc7, 0x5a, 0x15, 0x35, 0xa0, 0x7a, 0xd8,
	0xb7, 0xbb, 0x27, 0x46, 0x4f, 0xab, 0x21, 0x04, 0xab, 0x19, 0x2f, 0xc7, 0xea, 0x9c, 0x30, 0xd0,
	0x7b, 0x3d, 0xce, 0x06, 0x5e, 0x57, 0x17, 0xff, 0x30, 0x70, 0x6c, 0xad, 0xb1, 0xff, 0x6b, 0xfe,
	0x93, 0x2d, 0x2e, 0xb1, 0x03, 0x0f, 0x8f, 0x6d, 0xfb, 0xb8, 0x6f, 0x90, 0xef, 0xce, 0xcc, 0x2e,
	0xb9, 0x57, 0xd6, 0x0a, 0xda, 0x83, 0xcf, 0x4d, 0xc3, 0x39, 0x92, 0x76, 0xd1, 0xe8, 0x81, 0x8d,
	0x9d, 0xfb, 0x4c, 0x05, 0xed, 0xc3, 0xee, 0x8c, 0xa9, 0x0f, 0x06, 0x7d, 0xb3, 0xab, 0x4b, 0xc2,
	0x32, 0xb7, 0xb0, 0xff, 0x9b, 0x02, 0xea, 0xd2, 0xbe, 0xa0, 0x4d, 0x40, 0x86, 0x25, 0xea, 0xe4,
	0xcc, 0x4c, 0x5b, 0x6d, 0x65, 0x09, 0x37, 0x2d, 0xd3, 0x31, 0xf5, 0xbe, 0xa6, 0x70, 0x89, 0xe6,
	0xf0, 0xa7, 0xd8, 0x71, 0xb4, 0xc2, 0x12, 0xf8, 0x8c, 0x83, 0x45, 0xd4, 0x86, 0x8d, 0x39, 0xf0,
	0x95, 0x6e, 0xf5, 0x86, 0xaf, 0xf4, 0x13, 0x43, 0x2b, 0xed, 0xbf, 0x57, 0xa0, 0x3e, 0x7d, 0x54,
	0xe6, 0x5b, 0x6a, 0xbc, 0x36, 0x2c, 0x47, 0x5b, 0x41, 0x2a, 0x34, 0x06, 0x7a, 0xf7, 0x84, 0xb7,
	0x8f, 0x03, 0x22, 0x6b, 0x06, 0x60, 0xa3, 0x6b, 0x98, 0xaf, 0x8d, 0x9e, 0x56, 0x98, 0x63, 0xf5,
	0xed, 0x21, 0xcf, 0xb8, 0x05, 0xeb, 0xf3, 0x0a, 0xf4, 0xcd, 0x53, 0xd3, 0x31, 0x7a, 0x5a, 0x89,
	0x1b, 0x8c, 0x37, 0x8e, 0x81, 0x2d, 0xbd, 0x4f, 0x06, 0x3a, 0x9f, 0x1b, 0xc7, 0xc0, 0x43, 0xad,
	0xbc, 0x9f, 0x00, 0xba, 0xbf, 0x61, 0x9c, 0xfe, 0x1f, 0x3b, 0xa6, 0xad, 0xf0, 0x32, 0x1c, 0xdd,
	0xec, 0xf3, 0x7c, 0x43, 0x32, 0xc0, 0xf6, 0x21, 0xef, 0xc0, 0x06, 0x68, 0xd8, 0xb1, 0x17, 0xa9,
	0x05, 0x7e, 0x7b, 0x4e, 0x30, 0xad, 0xe3, 0x45, 0x4b, 0xf1, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x4a, 0x0f, 0xb7, 0x51, 0xc4, 0x0b, 0x00, 0x00,
}
