package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExposureSettings invokes the airec.DescribeExposureSettings API synchronously
// api document: https://help.aliyun.com/api/airec/describeexposuresettings.html
func (client *Client) DescribeExposureSettings(request *DescribeExposureSettingsRequest) (response *DescribeExposureSettingsResponse, err error) {
	response = CreateDescribeExposureSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExposureSettingsWithChan invokes the airec.DescribeExposureSettings API asynchronously
// api document: https://help.aliyun.com/api/airec/describeexposuresettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeExposureSettingsWithChan(request *DescribeExposureSettingsRequest) (<-chan *DescribeExposureSettingsResponse, <-chan error) {
	responseChan := make(chan *DescribeExposureSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExposureSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExposureSettingsWithCallback invokes the airec.DescribeExposureSettings API asynchronously
// api document: https://help.aliyun.com/api/airec/describeexposuresettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeExposureSettingsWithCallback(request *DescribeExposureSettingsRequest, callback func(response *DescribeExposureSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExposureSettingsResponse
		var err error
		defer close(result)
		response, err = client.DescribeExposureSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExposureSettingsRequest is the request struct for api DescribeExposureSettings
type DescribeExposureSettingsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeExposureSettingsResponse is the response struct for api DescribeExposureSettings
type DescribeExposureSettingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeExposureSettingsRequest creates a request to invoke DescribeExposureSettings API
func CreateDescribeExposureSettingsRequest() (request *DescribeExposureSettingsRequest) {
	request = &DescribeExposureSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2018-10-12", "DescribeExposureSettings", "/openapi/instances/[InstanceId]/exposure-settings", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeExposureSettingsResponse creates a response to parse from DescribeExposureSettings response
func CreateDescribeExposureSettingsResponse() (response *DescribeExposureSettingsResponse) {
	response = &DescribeExposureSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
