package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddGtmMonitor invokes the alidns.AddGtmMonitor API synchronously
// api document: https://help.aliyun.com/api/alidns/addgtmmonitor.html
func (client *Client) AddGtmMonitor(request *AddGtmMonitorRequest) (response *AddGtmMonitorResponse, err error) {
	response = CreateAddGtmMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// AddGtmMonitorWithChan invokes the alidns.AddGtmMonitor API asynchronously
// api document: https://help.aliyun.com/api/alidns/addgtmmonitor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGtmMonitorWithChan(request *AddGtmMonitorRequest) (<-chan *AddGtmMonitorResponse, <-chan error) {
	responseChan := make(chan *AddGtmMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddGtmMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddGtmMonitorWithCallback invokes the alidns.AddGtmMonitor API asynchronously
// api document: https://help.aliyun.com/api/alidns/addgtmmonitor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddGtmMonitorWithCallback(request *AddGtmMonitorRequest, callback func(response *AddGtmMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddGtmMonitorResponse
		var err error
		defer close(result)
		response, err = client.AddGtmMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddGtmMonitorRequest is the request struct for api AddGtmMonitor
type AddGtmMonitorRequest struct {
	*requests.RpcRequest
	MonitorExtendInfo string                      `position:"Query" name:"MonitorExtendInfo"`
	AddrPoolId        string                      `position:"Query" name:"AddrPoolId"`
	UserClientIp      string                      `position:"Query" name:"UserClientIp"`
	Name              string                      `position:"Query" name:"Name"`
	EvaluationCount   requests.Integer            `position:"Query" name:"EvaluationCount"`
	ProtocolType      string                      `position:"Query" name:"ProtocolType"`
	Interval          requests.Integer            `position:"Query" name:"Interval"`
	Lang              string                      `position:"Query" name:"Lang"`
	Timeout           requests.Integer            `position:"Query" name:"Timeout"`
	IspCityNode       *[]AddGtmMonitorIspCityNode `position:"Query" name:"IspCityNode"  type:"Repeated"`
}

// AddGtmMonitorIspCityNode is a repeated param struct in AddGtmMonitorRequest
type AddGtmMonitorIspCityNode struct {
	CityCode string `name:"CityCode"`
	IspCode  string `name:"IspCode"`
}

// AddGtmMonitorResponse is the response struct for api AddGtmMonitor
type AddGtmMonitorResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	MonitorConfigId string `json:"MonitorConfigId" xml:"MonitorConfigId"`
}

// CreateAddGtmMonitorRequest creates a request to invoke AddGtmMonitor API
func CreateAddGtmMonitorRequest() (request *AddGtmMonitorRequest) {
	request = &AddGtmMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "AddGtmMonitor", "Alidns", "openAPI")
	return
}

// CreateAddGtmMonitorResponse creates a response to parse from AddGtmMonitor response
func CreateAddGtmMonitorResponse() (response *AddGtmMonitorResponse) {
	response = &AddGtmMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
