package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDomainRecord invokes the alidns.UpdateDomainRecord API synchronously
// api document: https://help.aliyun.com/api/alidns/updatedomainrecord.html
func (client *Client) UpdateDomainRecord(request *UpdateDomainRecordRequest) (response *UpdateDomainRecordResponse, err error) {
	response = CreateUpdateDomainRecordResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDomainRecordWithChan invokes the alidns.UpdateDomainRecord API asynchronously
// api document: https://help.aliyun.com/api/alidns/updatedomainrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateDomainRecordWithChan(request *UpdateDomainRecordRequest) (<-chan *UpdateDomainRecordResponse, <-chan error) {
	responseChan := make(chan *UpdateDomainRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDomainRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDomainRecordWithCallback invokes the alidns.UpdateDomainRecord API asynchronously
// api document: https://help.aliyun.com/api/alidns/updatedomainrecord.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateDomainRecordWithCallback(request *UpdateDomainRecordRequest, callback func(response *UpdateDomainRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDomainRecordResponse
		var err error
		defer close(result)
		response, err = client.UpdateDomainRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDomainRecordRequest is the request struct for api UpdateDomainRecord
type UpdateDomainRecordRequest struct {
	*requests.RpcRequest
	RecordId     string           `position:"Query" name:"RecordId"`
	RR           string           `position:"Query" name:"RR"`
	Line         string           `position:"Query" name:"Line"`
	UserClientIp string           `position:"Query" name:"UserClientIp"`
	Lang         string           `position:"Query" name:"Lang"`
	Type         string           `position:"Query" name:"Type"`
	Priority     requests.Integer `position:"Query" name:"Priority"`
	Value        string           `position:"Query" name:"Value"`
	TTL          requests.Integer `position:"Query" name:"TTL"`
}

// UpdateDomainRecordResponse is the response struct for api UpdateDomainRecord
type UpdateDomainRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RecordId  string `json:"RecordId" xml:"RecordId"`
}

// CreateUpdateDomainRecordRequest creates a request to invoke UpdateDomainRecord API
func CreateUpdateDomainRecordRequest() (request *UpdateDomainRecordRequest) {
	request = &UpdateDomainRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "UpdateDomainRecord", "Alidns", "openAPI")
	return
}

// CreateUpdateDomainRecordResponse creates a response to parse from UpdateDomainRecord response
func CreateUpdateDomainRecordResponse() (response *UpdateDomainRecordResponse) {
	response = &UpdateDomainRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
