package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTraceCount invokes the arms.SearchTraceCount API synchronously
// api document: https://help.aliyun.com/api/arms/searchtracecount.html
func (client *Client) SearchTraceCount(request *SearchTraceCountRequest) (response *SearchTraceCountResponse, err error) {
	response = CreateSearchTraceCountResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTraceCountWithChan invokes the arms.SearchTraceCount API asynchronously
// api document: https://help.aliyun.com/api/arms/searchtracecount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchTraceCountWithChan(request *SearchTraceCountRequest) (<-chan *SearchTraceCountResponse, <-chan error) {
	responseChan := make(chan *SearchTraceCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTraceCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTraceCountWithCallback invokes the arms.SearchTraceCount API asynchronously
// api document: https://help.aliyun.com/api/arms/searchtracecount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SearchTraceCountWithCallback(request *SearchTraceCountRequest, callback func(response *SearchTraceCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTraceCountResponse
		var err error
		defer close(result)
		response, err = client.SearchTraceCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTraceCountRequest is the request struct for api SearchTraceCount
type SearchTraceCountRequest struct {
	*requests.RpcRequest
	ServiceIp     string                 `position:"Query" name:"ServiceIp"`
	OperationName string                 `position:"Query" name:"OperationName"`
	AppType       string                 `position:"Query" name:"AppType"`
	EndTime       requests.Integer       `position:"Query" name:"EndTime"`
	ServiceName   string                 `position:"Query" name:"ServiceName"`
	StartTime     requests.Integer       `position:"Query" name:"StartTime"`
	Tag           *[]SearchTraceCountTag `position:"Query" name:"Tag"  type:"Repeated"`
	MinDuration   requests.Integer       `position:"Query" name:"MinDuration"`
}

// SearchTraceCountTag is a repeated param struct in SearchTraceCountRequest
type SearchTraceCountTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// SearchTraceCountResponse is the response struct for api SearchTraceCount
type SearchTraceCountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSearchTraceCountRequest creates a request to invoke SearchTraceCount API
func CreateSearchTraceCountRequest() (request *SearchTraceCountRequest) {
	request = &SearchTraceCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-02-19", "SearchTraceCount", "", "")
	return
}

// CreateSearchTraceCountResponse creates a response to parse from SearchTraceCount response
func CreateSearchTraceCountResponse() (response *SearchTraceCountResponse) {
	response = &SearchTraceCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
