package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConsortiumMemberApproval invokes the baas.DescribeConsortiumMemberApproval API synchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummemberapproval.html
func (client *Client) DescribeConsortiumMemberApproval(request *DescribeConsortiumMemberApprovalRequest) (response *DescribeConsortiumMemberApprovalResponse, err error) {
	response = CreateDescribeConsortiumMemberApprovalResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConsortiumMemberApprovalWithChan invokes the baas.DescribeConsortiumMemberApproval API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummemberapproval.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumMemberApprovalWithChan(request *DescribeConsortiumMemberApprovalRequest) (<-chan *DescribeConsortiumMemberApprovalResponse, <-chan error) {
	responseChan := make(chan *DescribeConsortiumMemberApprovalResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConsortiumMemberApproval(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConsortiumMemberApprovalWithCallback invokes the baas.DescribeConsortiumMemberApproval API asynchronously
// api document: https://help.aliyun.com/api/baas/describeconsortiummemberapproval.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConsortiumMemberApprovalWithCallback(request *DescribeConsortiumMemberApprovalRequest, callback func(response *DescribeConsortiumMemberApprovalResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConsortiumMemberApprovalResponse
		var err error
		defer close(result)
		response, err = client.DescribeConsortiumMemberApproval(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConsortiumMemberApprovalRequest is the request struct for api DescribeConsortiumMemberApproval
type DescribeConsortiumMemberApprovalRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeConsortiumMemberApprovalResponse is the response struct for api DescribeConsortiumMemberApproval
type DescribeConsortiumMemberApprovalResponse struct {
	*responses.BaseResponse
	RequestId string                     `json:"RequestId" xml:"RequestId"`
	Success   bool                       `json:"Success" xml:"Success"`
	ErrorCode int                        `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ConsortiumMemberApproval `json:"Result" xml:"Result"`
}

// CreateDescribeConsortiumMemberApprovalRequest creates a request to invoke DescribeConsortiumMemberApproval API
func CreateDescribeConsortiumMemberApprovalRequest() (request *DescribeConsortiumMemberApprovalRequest) {
	request = &DescribeConsortiumMemberApprovalRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeConsortiumMemberApproval", "", "")
	return
}

// CreateDescribeConsortiumMemberApprovalResponse creates a response to parse from DescribeConsortiumMemberApproval response
func CreateDescribeConsortiumMemberApprovalResponse() (response *DescribeConsortiumMemberApprovalResponse) {
	response = &DescribeConsortiumMemberApprovalResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
