package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InviteUser invokes the baas.InviteUser API synchronously
// api document: https://help.aliyun.com/api/baas/inviteuser.html
func (client *Client) InviteUser(request *InviteUserRequest) (response *InviteUserResponse, err error) {
	response = CreateInviteUserResponse()
	err = client.DoAction(request, response)
	return
}

// InviteUserWithChan invokes the baas.InviteUser API asynchronously
// api document: https://help.aliyun.com/api/baas/inviteuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InviteUserWithChan(request *InviteUserRequest) (<-chan *InviteUserResponse, <-chan error) {
	responseChan := make(chan *InviteUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InviteUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InviteUserWithCallback invokes the baas.InviteUser API asynchronously
// api document: https://help.aliyun.com/api/baas/inviteuser.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) InviteUserWithCallback(request *InviteUserRequest, callback func(response *InviteUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InviteUserResponse
		var err error
		defer close(result)
		response, err = client.InviteUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InviteUserRequest is the request struct for api InviteUser
type InviteUserRequest struct {
	*requests.RpcRequest
	Bizid     string           `position:"Body" name:"Bizid"`
	Bid       string           `position:"Body" name:"Bid"`
	UserId    requests.Integer `position:"Body" name:"UserId"`
	UserEmail string           `position:"Body" name:"UserEmail"`
}

// InviteUserResponse is the response struct for api InviteUser
type InviteUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateInviteUserRequest creates a request to invoke InviteUser API
func CreateInviteUserRequest() (request *InviteUserRequest) {
	request = &InviteUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "InviteUser", "", "")
	return
}

// CreateInviteUserResponse creates a response to parse from InviteUser response
func CreateInviteUserResponse() (response *InviteUserResponse) {
	response = &InviteUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
