package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SynchronizeChaincode invokes the baas.SynchronizeChaincode API synchronously
// api document: https://help.aliyun.com/api/baas/synchronizechaincode.html
func (client *Client) SynchronizeChaincode(request *SynchronizeChaincodeRequest) (response *SynchronizeChaincodeResponse, err error) {
	response = CreateSynchronizeChaincodeResponse()
	err = client.DoAction(request, response)
	return
}

// SynchronizeChaincodeWithChan invokes the baas.SynchronizeChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/synchronizechaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SynchronizeChaincodeWithChan(request *SynchronizeChaincodeRequest) (<-chan *SynchronizeChaincodeResponse, <-chan error) {
	responseChan := make(chan *SynchronizeChaincodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SynchronizeChaincode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SynchronizeChaincodeWithCallback invokes the baas.SynchronizeChaincode API asynchronously
// api document: https://help.aliyun.com/api/baas/synchronizechaincode.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SynchronizeChaincodeWithCallback(request *SynchronizeChaincodeRequest, callback func(response *SynchronizeChaincodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SynchronizeChaincodeResponse
		var err error
		defer close(result)
		response, err = client.SynchronizeChaincode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SynchronizeChaincodeRequest is the request struct for api SynchronizeChaincode
type SynchronizeChaincodeRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	ChaincodeId    string `position:"Body" name:"ChaincodeId"`
}

// SynchronizeChaincodeResponse is the response struct for api SynchronizeChaincode
type SynchronizeChaincodeResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Success   bool                         `json:"Success" xml:"Success"`
	ErrorCode int                          `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInSynchronizeChaincode `json:"Result" xml:"Result"`
}

// CreateSynchronizeChaincodeRequest creates a request to invoke SynchronizeChaincode API
func CreateSynchronizeChaincodeRequest() (request *SynchronizeChaincodeRequest) {
	request = &SynchronizeChaincodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "SynchronizeChaincode", "", "")
	return
}

// CreateSynchronizeChaincodeResponse creates a response to parse from SynchronizeChaincode response
func CreateSynchronizeChaincodeResponse() (response *SynchronizeChaincodeResponse) {
	response = &SynchronizeChaincodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
