package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePredictiveJobs invokes the ccc.CreatePredictiveJobs API synchronously
// api document: https://help.aliyun.com/api/ccc/createpredictivejobs.html
func (client *Client) CreatePredictiveJobs(request *CreatePredictiveJobsRequest) (response *CreatePredictiveJobsResponse, err error) {
	response = CreateCreatePredictiveJobsResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePredictiveJobsWithChan invokes the ccc.CreatePredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/ccc/createpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePredictiveJobsWithChan(request *CreatePredictiveJobsRequest) (<-chan *CreatePredictiveJobsResponse, <-chan error) {
	responseChan := make(chan *CreatePredictiveJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePredictiveJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePredictiveJobsWithCallback invokes the ccc.CreatePredictiveJobs API asynchronously
// api document: https://help.aliyun.com/api/ccc/createpredictivejobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreatePredictiveJobsWithCallback(request *CreatePredictiveJobsRequest, callback func(response *CreatePredictiveJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePredictiveJobsResponse
		var err error
		defer close(result)
		response, err = client.CreatePredictiveJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePredictiveJobsRequest is the request struct for api CreatePredictiveJobs
type CreatePredictiveJobsRequest struct {
	*requests.RpcRequest
	InstanceId   string    `position:"Query" name:"InstanceId"`
	SkillGroupId string    `position:"Query" name:"SkillGroupId"`
	StrategyJson string    `position:"Query" name:"StrategyJson"`
	JobsJson     *[]string `position:"Query" name:"JobsJson"  type:"Repeated"`
}

// CreatePredictiveJobsResponse is the response struct for api CreatePredictiveJobs
type CreatePredictiveJobsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	JobGroupId     string `json:"JobGroupId" xml:"JobGroupId"`
}

// CreateCreatePredictiveJobsRequest creates a request to invoke CreatePredictiveJobs API
func CreateCreatePredictiveJobsRequest() (request *CreatePredictiveJobsRequest) {
	request = &CreatePredictiveJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "CreatePredictiveJobs", "", "")
	return
}

// CreateCreatePredictiveJobsResponse creates a response to parse from CreatePredictiveJobs response
func CreateCreatePredictiveJobsResponse() (response *CreatePredictiveJobsResponse) {
	response = &CreatePredictiveJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
