package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPredictiveJob invokes the ccc.GetPredictiveJob API synchronously
// api document: https://help.aliyun.com/api/ccc/getpredictivejob.html
func (client *Client) GetPredictiveJob(request *GetPredictiveJobRequest) (response *GetPredictiveJobResponse, err error) {
	response = CreateGetPredictiveJobResponse()
	err = client.DoAction(request, response)
	return
}

// GetPredictiveJobWithChan invokes the ccc.GetPredictiveJob API asynchronously
// api document: https://help.aliyun.com/api/ccc/getpredictivejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPredictiveJobWithChan(request *GetPredictiveJobRequest) (<-chan *GetPredictiveJobResponse, <-chan error) {
	responseChan := make(chan *GetPredictiveJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPredictiveJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPredictiveJobWithCallback invokes the ccc.GetPredictiveJob API asynchronously
// api document: https://help.aliyun.com/api/ccc/getpredictivejob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPredictiveJobWithCallback(request *GetPredictiveJobRequest, callback func(response *GetPredictiveJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPredictiveJobResponse
		var err error
		defer close(result)
		response, err = client.GetPredictiveJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPredictiveJobRequest is the request struct for api GetPredictiveJob
type GetPredictiveJobRequest struct {
	*requests.RpcRequest
	JobId      string `position:"Query" name:"JobId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// GetPredictiveJobResponse is the response struct for api GetPredictiveJob
type GetPredictiveJobResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Job            Job    `json:"Job" xml:"Job"`
}

// CreateGetPredictiveJobRequest creates a request to invoke GetPredictiveJob API
func CreateGetPredictiveJobRequest() (request *GetPredictiveJobRequest) {
	request = &GetPredictiveJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2017-07-05", "GetPredictiveJob", "", "")
	return
}

// CreateGetPredictiveJobResponse creates a response to parse from GetPredictiveJob response
func CreateGetPredictiveJobResponse() (response *GetPredictiveJobResponse) {
	response = &GetPredictiveJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
