package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAuthKey invokes the cloudauth.CreateAuthKey API synchronously
// api document: https://help.aliyun.com/api/cloudauth/createauthkey.html
func (client *Client) CreateAuthKey(request *CreateAuthKeyRequest) (response *CreateAuthKeyResponse, err error) {
	response = CreateCreateAuthKeyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAuthKeyWithChan invokes the cloudauth.CreateAuthKey API asynchronously
// api document: https://help.aliyun.com/api/cloudauth/createauthkey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAuthKeyWithChan(request *CreateAuthKeyRequest) (<-chan *CreateAuthKeyResponse, <-chan error) {
	responseChan := make(chan *CreateAuthKeyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAuthKey(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAuthKeyWithCallback invokes the cloudauth.CreateAuthKey API asynchronously
// api document: https://help.aliyun.com/api/cloudauth/createauthkey.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAuthKeyWithCallback(request *CreateAuthKeyRequest, callback func(response *CreateAuthKeyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAuthKeyResponse
		var err error
		defer close(result)
		response, err = client.CreateAuthKey(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAuthKeyRequest is the request struct for api CreateAuthKey
type CreateAuthKeyRequest struct {
	*requests.RpcRequest
	BizType      string           `position:"Query" name:"BizType"`
	UserDeviceId string           `position:"Query" name:"UserDeviceId"`
	SourceIp     string           `position:"Query" name:"SourceIp"`
	Test         requests.Boolean `position:"Query" name:"Test"`
	AuthYears    requests.Integer `position:"Query" name:"AuthYears"`
	Lang         string           `position:"Query" name:"Lang"`
}

// CreateAuthKeyResponse is the response struct for api CreateAuthKey
type CreateAuthKeyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	AuthKey   string `json:"AuthKey" xml:"AuthKey"`
}

// CreateCreateAuthKeyRequest creates a request to invoke CreateAuthKey API
func CreateCreateAuthKeyRequest() (request *CreateAuthKeyRequest) {
	request = &CreateAuthKeyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2018-09-16", "CreateAuthKey", "cloudauth", "openAPI")
	return
}

// CreateCreateAuthKeyResponse creates a response to parse from CreateAuthKey response
func CreateCreateAuthKeyResponse() (response *CreateAuthKeyResponse) {
	response = &CreateAuthKeyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
