package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSystemEventCount invokes the cms.DescribeSystemEventCount API synchronously
// api document: https://help.aliyun.com/api/cms/describesystemeventcount.html
func (client *Client) DescribeSystemEventCount(request *DescribeSystemEventCountRequest) (response *DescribeSystemEventCountResponse, err error) {
	response = CreateDescribeSystemEventCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSystemEventCountWithChan invokes the cms.DescribeSystemEventCount API asynchronously
// api document: https://help.aliyun.com/api/cms/describesystemeventcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSystemEventCountWithChan(request *DescribeSystemEventCountRequest) (<-chan *DescribeSystemEventCountResponse, <-chan error) {
	responseChan := make(chan *DescribeSystemEventCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSystemEventCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSystemEventCountWithCallback invokes the cms.DescribeSystemEventCount API asynchronously
// api document: https://help.aliyun.com/api/cms/describesystemeventcount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSystemEventCountWithCallback(request *DescribeSystemEventCountRequest, callback func(response *DescribeSystemEventCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSystemEventCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeSystemEventCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSystemEventCountRequest is the request struct for api DescribeSystemEventCount
type DescribeSystemEventCountRequest struct {
	*requests.RpcRequest
	Product        string `position:"Query" name:"Product"`
	Level          string `position:"Query" name:"Level"`
	GroupId        string `position:"Query" name:"GroupId"`
	Name           string `position:"Query" name:"Name"`
	EndTime        string `position:"Query" name:"EndTime"`
	EventType      string `position:"Query" name:"EventType"`
	StartTime      string `position:"Query" name:"StartTime"`
	SearchKeywords string `position:"Query" name:"SearchKeywords"`
	Status         string `position:"Query" name:"Status"`
}

// DescribeSystemEventCountResponse is the response struct for api DescribeSystemEventCount
type DescribeSystemEventCountResponse struct {
	*responses.BaseResponse
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           string            `json:"Success" xml:"Success"`
	SystemEventCounts SystemEventCounts `json:"SystemEventCounts" xml:"SystemEventCounts"`
}

// CreateDescribeSystemEventCountRequest creates a request to invoke DescribeSystemEventCount API
func CreateDescribeSystemEventCountRequest() (request *DescribeSystemEventCountRequest) {
	request = &DescribeSystemEventCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeSystemEventCount", "cms", "openAPI")
	return
}

// CreateDescribeSystemEventCountResponse creates a response to parse from DescribeSystemEventCount response
func CreateDescribeSystemEventCountResponse() (response *DescribeSystemEventCountResponse) {
	response = &DescribeSystemEventCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
