package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetImageScan invokes the cr.GetImageScan API synchronously
// api document: https://help.aliyun.com/api/cr/getimagescan.html
func (client *Client) GetImageScan(request *GetImageScanRequest) (response *GetImageScanResponse, err error) {
	response = CreateGetImageScanResponse()
	err = client.DoAction(request, response)
	return
}

// GetImageScanWithChan invokes the cr.GetImageScan API asynchronously
// api document: https://help.aliyun.com/api/cr/getimagescan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetImageScanWithChan(request *GetImageScanRequest) (<-chan *GetImageScanResponse, <-chan error) {
	responseChan := make(chan *GetImageScanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetImageScan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetImageScanWithCallback invokes the cr.GetImageScan API asynchronously
// api document: https://help.aliyun.com/api/cr/getimagescan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetImageScanWithCallback(request *GetImageScanRequest, callback func(response *GetImageScanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetImageScanResponse
		var err error
		defer close(result)
		response, err = client.GetImageScan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetImageScanRequest is the request struct for api GetImageScan
type GetImageScanRequest struct {
	*requests.RoaRequest
	RepoNamespace string `position:"Path" name:"RepoNamespace"`
	RepoName      string `position:"Path" name:"RepoName"`
	Tag           string `position:"Path" name:"Tag"`
}

// GetImageScanResponse is the response struct for api GetImageScan
type GetImageScanResponse struct {
	*responses.BaseResponse
}

// CreateGetImageScanRequest creates a request to invoke GetImageScan API
func CreateGetImageScanRequest() (request *GetImageScanRequest) {
	request = &GetImageScanRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetImageScan", "/repos/[RepoNamespace]/[RepoName]/tags/[Tag]/scan", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetImageScanResponse creates a response to parse from GetImageScan response
func CreateGetImageScanResponse() (response *GetImageScanResponse) {
	response = &GetImageScanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
