package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRepoBuildList invokes the cr.GetRepoBuildList API synchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildlist.html
func (client *Client) GetRepoBuildList(request *GetRepoBuildListRequest) (response *GetRepoBuildListResponse, err error) {
	response = CreateGetRepoBuildListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRepoBuildListWithChan invokes the cr.GetRepoBuildList API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoBuildListWithChan(request *GetRepoBuildListRequest) (<-chan *GetRepoBuildListResponse, <-chan error) {
	responseChan := make(chan *GetRepoBuildListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRepoBuildList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRepoBuildListWithCallback invokes the cr.GetRepoBuildList API asynchronously
// api document: https://help.aliyun.com/api/cr/getrepobuildlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetRepoBuildListWithCallback(request *GetRepoBuildListRequest, callback func(response *GetRepoBuildListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRepoBuildListResponse
		var err error
		defer close(result)
		response, err = client.GetRepoBuildList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRepoBuildListRequest is the request struct for api GetRepoBuildList
type GetRepoBuildListRequest struct {
	*requests.RoaRequest
	RepoNamespace string           `position:"Path" name:"RepoNamespace"`
	RepoName      string           `position:"Path" name:"RepoName"`
	PageSize      requests.Integer `position:"Query" name:"PageSize"`
	Page          requests.Integer `position:"Query" name:"Page"`
}

// GetRepoBuildListResponse is the response struct for api GetRepoBuildList
type GetRepoBuildListResponse struct {
	*responses.BaseResponse
}

// CreateGetRepoBuildListRequest creates a request to invoke GetRepoBuildList API
func CreateGetRepoBuildListRequest() (request *GetRepoBuildListRequest) {
	request = &GetRepoBuildListRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetRepoBuildList", "/repos/[RepoNamespace]/[RepoName]/build", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRepoBuildListResponse creates a response to parse from GetRepoBuildList response
func CreateGetRepoBuildListResponse() (response *GetRepoBuildListResponse) {
	response = &GetRepoBuildListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
