package cr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserSourceAccount invokes the cr.GetUserSourceAccount API synchronously
// api document: https://help.aliyun.com/api/cr/getusersourceaccount.html
func (client *Client) GetUserSourceAccount(request *GetUserSourceAccountRequest) (response *GetUserSourceAccountResponse, err error) {
	response = CreateGetUserSourceAccountResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserSourceAccountWithChan invokes the cr.GetUserSourceAccount API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceAccountWithChan(request *GetUserSourceAccountRequest) (<-chan *GetUserSourceAccountResponse, <-chan error) {
	responseChan := make(chan *GetUserSourceAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserSourceAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserSourceAccountWithCallback invokes the cr.GetUserSourceAccount API asynchronously
// api document: https://help.aliyun.com/api/cr/getusersourceaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetUserSourceAccountWithCallback(request *GetUserSourceAccountRequest, callback func(response *GetUserSourceAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserSourceAccountResponse
		var err error
		defer close(result)
		response, err = client.GetUserSourceAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserSourceAccountRequest is the request struct for api GetUserSourceAccount
type GetUserSourceAccountRequest struct {
	*requests.RoaRequest
	SourceOriginType string `position:"Query" name:"SourceOriginType"`
}

// GetUserSourceAccountResponse is the response struct for api GetUserSourceAccount
type GetUserSourceAccountResponse struct {
	*responses.BaseResponse
}

// CreateGetUserSourceAccountRequest creates a request to invoke GetUserSourceAccount API
func CreateGetUserSourceAccountRequest() (request *GetUserSourceAccountRequest) {
	request = &GetUserSourceAccountRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("cr", "2016-06-07", "GetUserSourceAccount", "/users/sourceAccount", "cr", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetUserSourceAccountResponse creates a response to parse from GetUserSourceAccount response
func CreateGetUserSourceAccountResponse() (response *GetUserSourceAccountResponse) {
	response = &GetUserSourceAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
